/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.csv;

/**
 * @author Kappich Systemberatung
 */
public enum CsvPriority {
    CLO("Koordinaten, Linie, Objekt", new GeoType[] {GeoType.COORDINATES, GeoType.LINE_WITH_OFFSET, GeoType.OBJECT_REFERENCE}),
    COL("Koordinaten, Objekt, Linie", new GeoType[] {GeoType.COORDINATES, GeoType.OBJECT_REFERENCE, GeoType.LINE_WITH_OFFSET}),
    LCO("Linie, Koordinaten, Objekt", new GeoType[] {GeoType.LINE_WITH_OFFSET, GeoType.COORDINATES, GeoType.OBJECT_REFERENCE}),
    LOC("Linie, Objekt, Koordinaten", new GeoType[] {GeoType.LINE_WITH_OFFSET, GeoType.OBJECT_REFERENCE, GeoType.COORDINATES}),
    OCL("Objekt, Koordinaten, Linie", new GeoType[] {GeoType.OBJECT_REFERENCE, GeoType.COORDINATES, GeoType.LINE_WITH_OFFSET}),
    OLC("Objekt, Linie, Koordinaten", new GeoType[] {GeoType.OBJECT_REFERENCE, GeoType.LINE_WITH_OFFSET, GeoType.COORDINATES});

    private static final CsvPriority DEFAULT_PRIOROTY = CLO;

    private final String _description;
    private final GeoType[] _geoTypes;

    CsvPriority(String description, GeoType[] geoTypes) {
        _description = description;
        _geoTypes = geoTypes;
    }

    public static CsvPriority getCsvPriority(final String description) {
        for (CsvPriority priority : values()) {
            if (priority.getDescription().equals(description)) {
                return priority;
            }
        }
        return DEFAULT_PRIOROTY;
    }

    public static CsvPriority getDefaultPrioroty() {
        return DEFAULT_PRIOROTY;
    }

    public String getDescription() {
        return _description;
    }

    public GeoType getFirst() {
        return _geoTypes[0];
    }

    public GeoType getSecond() {
        return _geoTypes[1];
    }

    public GeoType getThird() {
        return _geoTypes[2];
    }

    @Override
    public String toString() {
        return getDescription();
    }

    public enum GeoType {
        COORDINATES, LINE_WITH_OFFSET, OBJECT_REFERENCE
    }
}
