/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.csv;

import de.bsvrz.sys.funclib.kappich.annotations.Nullable;

/**
 * @author Kappich Systemberatung
 */
public enum CsvSeparator {
    COMMA(',', ","), SEMICOLON(';', ";"), COLON(':', ":"), TABULATOR('\t', "(Tabulator)"), SPACE(' ', "(Leerzeichen)");

    private final char _c;
    private final String _description;

    CsvSeparator(char c, String description) {
        _c = c;
        _description = description;
    }

    public static boolean isAllowedSeparator(char c) {
        for (final CsvSeparator value : values()) {
            if (c == value.getCharacter()) {
                return true;
            }
        }
        return false;
    }

    public static boolean isAllowedSeparator(String s) {
        return !(null == s || 1 != s.length()) && isAllowedSeparator(s.charAt(0));
    }

    @Nullable
    public static CsvSeparator getSeparator(char c) {
        for (final CsvSeparator value : values()) {
            if (c == value.getCharacter()) {
                return value;
            }
        }
        return null;
    }

    @Nullable
    public static CsvSeparator getSeparator(String s) {
        if (null != s && 1 == s.length()) {
            return getSeparator(s.charAt(0));
        }
        return null;
    }

    public char getCharacter() {
        return _c;
    }

    public String getDescription() {
        return _description;
    }

    @Override
    public String toString() {
        return getDescription();
    }
}
