/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.displayObjectToolkit;

import de.kappich.pat.gnd.gnd.MapPane;
import de.kappich.pat.gnd.pluginInterfaces.DisplayObjectPainter;
import de.kappich.pat.gnd.pluginInterfaces.DisplayObjectType.DisplayObjectTypeItem;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.List;

/**
 * Das Interface {@code DisplayObject} beschreibt die gemeinsamen Eigenschaften aller darstellbaren Objekte.
 *
 * @author Kappich Systemberatung
 */
public interface DisplayObject extends MapPane.MapScaleListener {

    /**
     * Gibt einen Namen des Objekts zurück, mit dessen Hilfe der Benutzer ihn identifiezieren können soll.
     *
     * @return ein Name
     */
    String getName();

    /**
     * Gibt die Koordinaten zu dem dem übergebenen (Koordinaten-)Typ zurück. Bei Linien ist der Typ gleich dem Verschiebungswert.
     *
     * @param type der Koordinatentyp
     *
     * @return die Koordinaten
     */
    List<Object> getCoordinates(int type);

    /**
     * Gibt die Koordinaten zum Default(-Koordinaten)-Typ zurück.
     *
     * @return die Default-Koordinaten
     */
    List<Object> getCoordinates();

    /**
     * Gibt eine oder mehrere Referenz-Koordinaten für das {@code DisplayObject} zurück, die etwa zum Anzeigen von Namen genutzt werden können. Diese
     * Referenzpunkte sollten innerhalb des übergebenen Rechtecks liegen. Es obliegt der Implementaton zu entscheiden, wieviele Referenzpunkte
     * zurückgegeben werden (und der Anwendung, welche sie benutzt).
     *
     * @param utmBounds
     *
     * @return die Referenz-Punkte
     */
    List<Point2D> getReferencePoints(Rectangle utmBounds);

    /**
     * Gibt das Painter-Objekt {@link DisplayObjectPainter} zu dieses OnlineDisplayObject zurück.
     *
     * @return den Painter
     */
    DisplayObjectPainter getPainter();

    void setPainter(DisplayObjectPainter painter);

    /**
     * Gibt die {@link DOTCollection} zu diesem OnlineDisplayObject zurück.
     *
     * @return die DOTCollection
     */
    DOTCollection getDOTCollection();

    /**
     * Gibt die umgebende Rechteck zu diesem OnlineDisplayObject für den angebenen (Koordinaten-)Typ zurück.
     *
     * @param type der Typ
     *
     * @return das umgebende Rechteck
     */
    Rectangle getBoundingRectangle(int type);

    /**
     * Gibt die umgebende Rechteck zu diesem OnlineDisplayObject für den Default-(Koordinaten-)Typ zurück.
     *
     * @return das umgebende Rechteck
     */
    Rectangle getBoundingRectangle();

    /**
     * Setzt den Default-Type.
     *
     * @param defaultType der Default-(Koordinaten-)Typ
     */
    void setDefaultType(int defaultType);

    /**
     * Gibt das aktuell gültige {@link DisplayObjectTypeItem} für das {@link PrimitiveFormPropertyPair pair} zurück.
     *
     * @param pair das Paar
     *
     * @return das aktuell gültige DisplayObjectTypeItem oder {@code null}, wenn kein solches existiert
     */
    DisplayObjectTypeItem getDisplayObjectTypeItem(PrimitiveFormPropertyPair pair);
}
