/*
 * Copyright 2009-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.displayObjectToolkit;

import static de.kappich.pat.gnd.pointPlugin.DOTPoint.PrimitiveForm;


import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.kappich.pat.gnd.properties.Property;

/**
 * Ein PrimitiveFormPropertyPair kapselt ein Paar bestehend aus einer Grundfigur ({@link PrimitiveForm}), die durch ihren Namen angegeben wird, und
 * einer Visualisierungs-Eigenschaft ({@link Property}).
 *
 * @author Kappich Systemberatung
 */
public class PrimitiveFormPropertyPair {

    private final String _primitiveFormName;
    private final Property _property;

    /**
     * Konstruiert ein Objekt aus den übergebenen Daten. Der Name der Grundfigur darf {@code null} sein, die Eigenschaft nicht.
     *
     * @param primitiveFormName ein Grundfigurname oder {@code null}
     * @param property          eine Visualisierungseigenschaft
     */
    public PrimitiveFormPropertyPair(@Nullable String primitiveFormName, Property property) {
        super();
        if (property == null) {
            throw new IllegalArgumentException("OnlineDisplayObject.ObjectPropertyPair muss mit echten Property konstruiert werden");
        }
        _primitiveFormName = primitiveFormName;
        _property = property;
    }

    /**
     * Der Getter für den Namen der Grundfigur.
     *
     * @return der Grundfigurname oder {@code null}
     */
    @Nullable
    public String getPrimitiveFormName() {
        return _primitiveFormName;
    }

    /**
     * Der Getter für die Eigenschaft.
     *
     * @return die Eigenschaft
     */
    public Property getProperty() {
        return _property;
    }

    /**
     * Eine einfache Selbstbeschreibung.
     *
     * @return die Selbstbeschreibung
     */
    @Override
    public String toString() {
        return "[ObjectPropertyPair: o=" + _primitiveFormName + ", property=" + _property.toString() + "]";
    }

    /**
     * Komponentenweiser Vergleich.
     *
     * @return {@code true} genau dann, wenn Gleichheit vorliegt
     */
    @Override
    public boolean equals(Object o) {
	    if (!(o instanceof PrimitiveFormPropertyPair opp)) {
            return false;
        }
        if (_primitiveFormName == null) {
            return opp._primitiveFormName == null && _property.equals(opp._property);
        } else {
            return _primitiveFormName.equals(opp._primitiveFormName) && _property.equals(opp._property);
        }
    }

    /**
     * Ein Hashcode aus den Komponenten
     *
     * @return der Hashcode
     */
    @Override
    public int hashCode() {
        if (_primitiveFormName == null) {
            return _property.hashCode();
        } else {
            return _primitiveFormName.hashCode() + _property.hashCode();
        }
    }
}
