/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.extLocRef;

import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

/**
 * Diese Klasse verkapselt eine Liste von {@link ComposedReference ComposedReferences} und ist zugleich ein TableModel.
 *
 * @author Kappich Systemberatung
 */
@SuppressWarnings("NonSerializableFieldInSerializableClass")
public class CRCollection extends AbstractTableModel {

    private static final String[] _columnNames = {"Erweiterte Ortsreferenz (EOR):"};
    private final List<ComposedReference> _composedReferences;

    public CRCollection() {
        _composedReferences = new ArrayList<>();
    }

    public CRCollection(final List<ComposedReference> composedReferences) {
        _composedReferences = new ArrayList<>(composedReferences);
    }

    public boolean add(final ComposedReference composedReference) {
        for (ComposedReference cr : _composedReferences) {
            if (composedReference.getName().equals(cr.getName())) {
                return false;
            }
        }
        _composedReferences.add(composedReference);
        fireTableDataChanged();
        return true;
    }

    public boolean remove(final ComposedReference composedReference) {
        for (int i = 0; i < _composedReferences.size(); ++i) {
            if (composedReference.getName().equals(_composedReferences.get(i).getName())) {
                _composedReferences.remove(i);
                fireTableDataChanged();
                return true;
            }
        }
        return false;
    }

    /**
     * Diese Methode ändert die Reihenfolge der EOR. Alle EOR, deren Indizes übergeben werden, werden in der Reihenfolge um eins naoch oben
     * verschoben. Dazu darf der Index 0 nicht in dem Array enthalten sein. Die Indizes müssen nicht sortiert sein: das macht die Methode selber.
     *
     * @param indices Indizes
     *
     * @return
     */
    public boolean moveUpwards(final int[] indices) {
        if (indices.length == 0) {
            return true;
        }
        Arrays.sort(indices);
        if (0 == indices[0]) {
            return false;
        }
        for (final int index : indices) {
            Collections.swap(_composedReferences, index - 1, index);
        }
        fireTableDataChanged();
        return true;
    }

    public ComposedReference get(final int index) {
        return _composedReferences.get(index);
    }

    public int size() {
        return _composedReferences.size();
    }

    public boolean isEmpty() {
        return _composedReferences.isEmpty();
    }

    public void clear() {
        _composedReferences.clear();
    }

    /*
    Es ist durchaus Absicht, dass hier auf das Original zugegriffen wird und Veränderungen
    möglich sind.
     */
    @SuppressWarnings("ReturnOfCollectionOrArrayField")
    public List<ComposedReference> getComposedReferences() {
        return _composedReferences;
    }

    public boolean contains(final ComposedReference reference) {
        for (ComposedReference reference1 : _composedReferences) {
            if (reference.getName().equals(reference1.getName())) {
                return true;
            }
        }
        return false;
    }

    /* Implementation des TableModel */
    @Override
    public int getRowCount() {
        return _composedReferences.size();
    }

    @Override
    public int getColumnCount() {
        return _columnNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return _columnNames[columnIndex];
    }

    @Nullable
    @Override
    public Object getValueAt(final int rowIndex, final int columnIndex) {
        if (0 == columnIndex) {
            return _composedReferences.get(rowIndex);
        }
        return null;
    }
    /* Ende der Implementation des TableModel */

    @Override
    public String toString() {
        return "CRCollection{" + "_composedReferences=" + _composedReferences + '}';
    }
}
