/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.kmPlugin;

import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.kappich.pat.gnd.properties.PropertyValue;
import java.util.prefs.Preferences;

/**
 * {@code KmFormat} ist eine Enumeration aller möglichen Formate der Kilometrierungsinformation. Die einzelnen Werte besiztzen eine eindeutige
 * Ordinalzahl.
 *
 * @author Kappich Systemberatung
 */
public enum KmFormat implements PropertyValue {

    KM_ONLY("Nur den Kilometerwert anzeigen", 0),               // 405,1
    RN_AND_KM("Straßenname und Kilometerwert anzeigen", 1),     // A1: 405,1
    RN_BN_AND_KM("Straßenname, Blocknummer und Kilometerwert anzeigen", 2), // A1/0103: 405,1
    RN_ONLY("Nur den Straßennamen anzeigen", 3);                // A1

    private final String _description;
    private final int _ordinal;

    KmFormat(final String description, final int ordinal) {
        _description = description;
        _ordinal = ordinal;
    }

    /**
     * Gibt das {@code KmFormat}-Objekt zu der übergebenen Ordinalzahl zurück, bzw. {@code null}, wenn kein solches Objekt existiert.
     *
     * @param ordinal die Ordinalzahl
     *
     * @return das Objekt
     */
    @Nullable
    public static KmFormat getFormat(int ordinal) {
        for (KmFormat format : KmFormat.values()) {
            if (format.getOrdinal() == ordinal) {
                return format;
            }
        }
        return null;
    }

    @Override
    public void putPreferences(final Preferences prefs) {
        prefs.putInt("PROPERTY_VALUE", getOrdinal());
    }

    /**
     * Gibt die Ordinalzahl des {@code KmFormat}-Objekts zurück.
     *
     * @return die Ordinalzahl
     */
    public int getOrdinal() {
        return _ordinal;
    }

    @Override
    public String toString() {
        return _description;
    }
}
