/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.kmPlugin;

import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.debug.Debug;
import de.kappich.pat.gnd.displayObjectToolkit.DOTCollection;
import de.kappich.pat.gnd.displayObjectToolkit.DisplayObject;
import de.kappich.pat.gnd.displayObjectToolkit.GeoInitializer;
import de.kappich.pat.gnd.gnd.MapPane;
import de.kappich.pat.gnd.layerManagement.Layer;
import de.kappich.pat.gnd.pluginInterfaces.DisplayObjectPainter;
import de.kappich.pat.gnd.pluginInterfaces.DisplayObjectsInitializer;
import java.util.List;
import javax.swing.JProgressBar;

/**
 * Dies ist die Implementierung des {@code DisplayObjectsInitializers} im Km-Plugin.
 *
 * @author Kappich Systemberatung
 */
public class KmInitializer implements DisplayObjectsInitializer {

    private static final Debug _debug = Debug.getLogger();

    @Override
    public void initializeDisplayObjects(final DataModel configuration, final Layer layer, final MapPane mapPane, final JProgressBar progressBar,
                                         List<DisplayObject> returnList) {
        final String geoReferenceType = layer.getConfigurationObjectType();
        final SystemObjectType systemObjectType = configuration.getType(geoReferenceType);
        if (systemObjectType == null) {
            _debug.warning("Der Typ " + geoReferenceType + " ist in der Konfiguration unbekannt.");
            return;
        }
        SystemObjectType lineType = configuration.getType("typ.linie");
        if (!systemObjectType.inheritsFrom(lineType)) {
            _debug.warning("Der Typ " + lineType.getName() + " ist kein Linientyp.");
            return;
        }
        DisplayObjectPainter painter = new DOTKmPainter();
        final DOTCollection dotCollection = layer.getDotCollection();

//		Long time = System.currentTimeMillis();
        GeoInitializer.getInstance().createKmDisplayObjects(painter, dotCollection, returnList);
//		System.out.println("KM: " + (System.currentTimeMillis() - time) + " Millisekunden");
//		System.out.println("KM: " + returnList.size() + " Objekte.");
    }
}
