/*
 * Copyright 2011-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.notice;

import java.util.Objects;

/**
 * @author Kappich Systemberatung
 */
public class Notice {

    private final String _message;

    private final long _creationTime;

    private final long _changeTime;

    public Notice(String message) {
        this(message, System.currentTimeMillis());
    }

    public Notice(final String message, final long creationTime) {
        this(message, creationTime, creationTime);
    }

    public Notice(final String message, final long creationTime, final long changeTime) {
        _message = message;
        _creationTime = creationTime;
        _changeTime = changeTime;
    }

    public String getMessage() {
        return _message;
    }

    public long getCreationTime() {
        return _creationTime;
    }

    public long getChangeTime() {
        return _changeTime;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final Notice notice = (Notice) o;

        if (_changeTime != notice._changeTime) {
            return false;
        }
        if (_creationTime != notice._creationTime) {
            return false;
        }
	    if (!Objects.equals(_message, notice._message)) {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode() {
        int result = _message != null ? _message.hashCode() : 0;
	    result = 31 * result + Long.hashCode(_creationTime);
	    result = 31 * result + Long.hashCode(_changeTime);
        return result;
    }

    @Override
    public String toString() {
        return "Notice{" + "_message='" + _message + '\'' + ", _creationTime=" + _creationTime + ", _changeTime=" + _changeTime + '}';
    }
}
