/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.properties;

import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.kappich.pat.gnd.kmPlugin.KmFormat;
import de.kappich.pat.gnd.utils.SpringUtilities;
import java.awt.Dimension;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

/**
 * Diese Klasse verkapselt die Eigenschaft Kilometrierungsformat.
 *
 * @author Kappich Systemberatung
 */
public final class KmFormatProperty extends AbstractProperty {
    private static final KmFormatProperty _instance = new KmFormatProperty();
    private static final String KEY = "kmformat";
    private static final KmFormat DEFAULT_KM_FORMAT = KmFormat.KM_ONLY;

    private KmFormatProperty() {
        super("KM-Format");
    }

    public static Property getInstance() {
        return _instance;
    }

    @Override
    public Object getDefaultValue() {
        return DEFAULT_KM_FORMAT;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public PropertyPanel getPropertyPanel(@Nullable Object value, boolean changeable) {
        if (value != null) {
            return new KmFormatPanel((KmFormat) value, changeable);
        } else {
            return new KmFormatPanel(DEFAULT_KM_FORMAT, changeable);
        }
    }

    private static class KmFormatPanel extends JPanel implements PropertyPanel {
        private static final Object[] KM_FORMAT_ITEMS = {KmFormat.KM_ONLY, KmFormat.RN_AND_KM, KmFormat.RN_BN_AND_KM, KmFormat.RN_ONLY};
        private final JComboBox<Object> _kmFormatComboBox = new JComboBox<>(KM_FORMAT_ITEMS);

        public KmFormatPanel(KmFormat kmType, boolean changeable) {
            JLabel label = new JLabel("Anzeigeformat: ");
            _kmFormatComboBox.setMaximumSize(new Dimension(200, 25));
            _kmFormatComboBox.getModel().setSelectedItem(kmType);
            _kmFormatComboBox.setEnabled(changeable);
            setLayout(new SpringLayout());
            add(label);
            add(_kmFormatComboBox);
            SpringUtilities.makeCompactGrid(this, 2, 5, 5);
        }

        @Override
        public void addListener(final PropertyPanelListener listener) {
            ItemListener itemListener = e -> listener.stateChanged();
            _kmFormatComboBox.addItemListener(itemListener);
        }

        @Override
        public Object getPropertyValue() {
            return _kmFormatComboBox.getSelectedItem();
        }

        @Override
        public void setSelectionEnabled(final boolean enabled) {
            _kmFormatComboBox.setEnabled(enabled);
        }
    }
}
