/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.properties;

import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.kappich.pat.gnd.rnPlugin.RnFormat;
import de.kappich.pat.gnd.utils.SpringUtilities;
import java.awt.Dimension;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

/**
 * Diese Klasse verkapselt die Eigenschaft Routennummerformat.
 *
 * @author Kappich Systemberatung
 */
public final class RnFormatProperty extends AbstractProperty {

    private static final RnFormatProperty _instance = new RnFormatProperty();
    private static final String KEY = "rnformat";

    private static final RnFormat DEFAULT_RN_FORMAT = RnFormat.RN_BIG;

    private RnFormatProperty() {
        super("Autobahnschilder");
    }

    public static Property getInstance() {
        return _instance;
    }

    @Override
    public Object getDefaultValue() {
        return DEFAULT_RN_FORMAT;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public PropertyPanel getPropertyPanel(@Nullable Object value, boolean changeable) {
        if (value != null) {
            return new RnFormatPanel((RnFormat) value, changeable);
        } else {
            return new RnFormatPanel(DEFAULT_RN_FORMAT, changeable);
        }
    }

    private static class RnFormatPanel extends JPanel implements PropertyPanel {
        private static final Object[] RN_FORMAT_ITEMS = {RnFormat.RN_BIG, RnFormat.RN_SMALL};
        private final JComboBox<Object> _rnFormatComboBox = new JComboBox<>(RN_FORMAT_ITEMS);

        public RnFormatPanel(RnFormat rnFormat, boolean changeable) {
            JLabel label = new JLabel("Größe: ");
            _rnFormatComboBox.setMaximumSize(new Dimension(200, 25));
            _rnFormatComboBox.getModel().setSelectedItem(rnFormat);
            _rnFormatComboBox.setEnabled(changeable);
            setLayout(new SpringLayout());
            add(label);
            add(_rnFormatComboBox);
            SpringUtilities.makeCompactGrid(this, 2, 5, 5);
        }

        @Override
        public void addListener(final PropertyPanelListener listener) {
            ItemListener itemListener = e -> listener.stateChanged();
            _rnFormatComboBox.addItemListener(itemListener);
        }

        @Override
        public Object getPropertyValue() {
            return _rnFormatComboBox.getSelectedItem();
        }

        @Override
        public void setSelectionEnabled(final boolean enabled) {
            _rnFormatComboBox.setEnabled(enabled);
        }
    }
}
