/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.properties;

import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.kappich.pat.gnd.statPlugin.StatFormat;
import de.kappich.pat.gnd.utils.SpringUtilities;
import java.awt.Dimension;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

/**
 * Diese Klasse verkapselt die Eigenschaft Stationierungsformat.
 *
 * @author Kappich Systemberatung
 */
public final class StatFormatProperty extends AbstractProperty {
    private static final StatFormatProperty _instance = new StatFormatProperty();
    private static final String KEY = "statformat";
    private static final StatFormat DEFAULT_STAT_FORMAT = StatFormat.STAT_ONLY;

    private StatFormatProperty() {
        super("Stat-Format");
    }

    public static Property getInstance() {
        return _instance;
    }

    @Override
    public Object getDefaultValue() {
        return DEFAULT_STAT_FORMAT;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public PropertyPanel getPropertyPanel(@Nullable Object value, boolean changeable) {
        if (value != null) {
            return new StatFormatPanel((StatFormat) value, changeable);
        } else {
            return new StatFormatPanel(DEFAULT_STAT_FORMAT, changeable);
        }
    }

    private static class StatFormatPanel extends JPanel implements PropertyPanel {
        private static final Object[] STAT_FORMAT_ITEMS = {StatFormat.STAT_ONLY, StatFormat.SECTION_AND_STAT};
        private final JComboBox<Object> _statFormatComboBox = new JComboBox<>(STAT_FORMAT_ITEMS);

        public StatFormatPanel(StatFormat statFormat, boolean changeable) {
            JLabel label = new JLabel("Anzeigeformat: ");
            _statFormatComboBox.setMaximumSize(new Dimension(200, 25));
            _statFormatComboBox.getModel().setSelectedItem(statFormat);
            _statFormatComboBox.setEnabled(changeable);
            setLayout(new SpringLayout());
            add(label);
            add(_statFormatComboBox);
            SpringUtilities.makeCompactGrid(this, 2, 5, 5);
        }

        @Override
        public void addListener(final PropertyPanelListener listener) {
            ItemListener itemListener = e -> listener.stateChanged();
            _statFormatComboBox.addItemListener(itemListener);
        }

        @Override
        public Object getPropertyValue() {
            return _statFormatComboBox.getSelectedItem();
        }

        @Override
        public void setSelectionEnabled(final boolean enabled) {
            _statFormatComboBox.setEnabled(enabled);
        }
    }
}
