/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.properties;

import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.kappich.pat.gnd.utils.SpringUtilities;
import java.awt.Dimension;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

/**
 * Diese Klasse verkapselt die Texteigenschaft.
 *
 * @author Kappich Systemberatung
 */
public final class TextProperty extends AbstractProperty {
    private static final TextProperty _instance = new TextProperty();
    private static final String KEY = "text";
    private static final String DEFAULT_TEXT = "Ein veränderbarer Text";

    private TextProperty() {
        super("Text");
    }

    public static Property getInstance() {
        return _instance;
    }

    @Override
    public Object getDefaultValue() {
        return DEFAULT_TEXT;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public PropertyPanel getPropertyPanel(@Nullable Object value, boolean changeable) {
        if (value != null) {
            return new TextPropertyPanel((String) value, changeable);
        } else {
            return new TextPropertyPanel(DEFAULT_TEXT, changeable);
        }
    }

    private static class TextPropertyPanel extends JPanel implements PropertyPanel {
        private static final String GET_NAME_OR_PID_OR_ID = "Vordefinierte Funktion: Name, PID oder Id";
        private static final String GET_NAME = "Vordefinierte Funktion: Name";
        private static final String GET_PID_OR_ID = "Vordefinierte Funktion: PID oder Id";
        private static final String GET_INFO_GET_DESCRIPTION = "Vordefinierte Funktion: Beschreibung";
        private static final String[] TEXT_ITEMS =
            {GET_NAME_OR_PID_OR_ID, GET_NAME, GET_PID_OR_ID, GET_INFO_GET_DESCRIPTION, "Ein veränderbarer Text"};
        private final JComboBox<String> _textItemComboBox = new JComboBox<>(TEXT_ITEMS);

        public TextPropertyPanel(String text, boolean changeable) {
            JLabel label = new JLabel("Text: ");
            _textItemComboBox.setMaximumSize(new Dimension(200, 20));
            _textItemComboBox.setSelectedItem(text);
            _textItemComboBox.setEnabled(changeable);
            setLayout(new SpringLayout());
            add(label);
            add(_textItemComboBox);
            SpringUtilities.makeCompactGrid(this, 2, 5, 5);
        }

        @Override
        public void addListener(final PropertyPanelListener listener) {
            ItemListener itemListener = e -> listener.stateChanged();
            _textItemComboBox.addItemListener(itemListener);
        }

        @Override
        public Object getPropertyValue() {
            return _textItemComboBox.getSelectedItem();
        }

        @Override
        public void setSelectionEnabled(final boolean enabled) {
            _textItemComboBox.setEnabled(enabled);
        }
    }
}
