/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.rnPlugin;

import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.kappich.pat.gnd.displayObjectToolkit.DisplayObject;
import de.kappich.pat.gnd.gnd.MapPane;
import de.kappich.pat.gnd.pluginInterfaces.DisplayObjectPainter;
import de.kappich.pat.gnd.properties.RnFormatProperty;
import de.kappich.pat.gnd.utils.PointWithAngle;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.ImageIcon;

/**
 * Dies ist die Implemenation des {@link DisplayObjectPainter} im Km-Plugin.
 *
 * @author Kappich Systemberatung
 */
public class DOTRnPainter implements DisplayObjectPainter {

    private static final boolean IS_MAC = System.getProperty("os.name").toLowerCase().startsWith("mac");

    private static final AffineTransform IDENTITY = new AffineTransform();

    private static final ImageIcon BIG_ICON = new ImageIcon(DOTRnPainter.class.getResource("/de/kappich/pat/gnd/res/Autobahn32.png"));
    private static final ImageIcon SMALL_ICON = new ImageIcon(DOTRnPainter.class.getResource("/de/kappich/pat/gnd/res/Autobahn24.png"));
    private static final int HALF_BIG_ICON_WIDTH;
    private static final int HALF_BIG_ICON_HEIGHT;
    private static final int HALF_SMALL_ICON_WIDTH;
    private static final int HALF_SMALL_ICON_HEIGHT;

    static {
        HALF_BIG_ICON_WIDTH = BIG_ICON.getIconWidth() / 2;
        HALF_BIG_ICON_HEIGHT = BIG_ICON.getIconHeight() / 2;
        HALF_SMALL_ICON_WIDTH = SMALL_ICON.getIconWidth() / 2;
        HALF_SMALL_ICON_HEIGHT = SMALL_ICON.getIconHeight() / 2;
    }

    private static void drawIcon32(Graphics2D g2D, final Integer rn, int x, int y) {
//		// Bringt nichts, weil  RenderingHints.VALUE_RENDER_QUALITY schon der Wert ist
//		/* TEST */
//		Object kr = g2D.getRenderingHint(RenderingHints.KEY_RENDERING);
//		g2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
//		/* TEST */

        int realX = x - HALF_BIG_ICON_WIDTH;
        int realY = y - HALF_BIG_ICON_HEIGHT;

        BIG_ICON.paintIcon(null, g2D, realX, realY);
        Color oldColor = g2D.getColor();
        Font oldFont = g2D.getFont();
        g2D.setColor(Color.white);
        Font font = new Font("Dialog", Font.BOLD, 12);
        g2D.setFont(font);
        if (!IS_MAC) {
            if (rn < 10) {
                g2D.drawString(rn.toString(), realX + 13, realY + 14);
            } else if (rn < 100) {
                g2D.drawString(rn.toString(), realX + 10, realY + 14);
            } else {
                g2D.drawString(rn.toString(), realX + 6, realY + 14);
            }
        } else {
            if (rn < 10) {
                g2D.drawString(rn.toString(), realX + 12, realY + 14);
            } else if (rn < 100) {
                g2D.drawString(rn.toString(), realX + 8, realY + 14);
            } else {
                g2D.drawString(rn.toString(), realX + 4, realY + 14);
            }
        }
        g2D.setColor(oldColor);
        g2D.setFont(oldFont);
//		/* TEST */
//		g2D.setRenderingHint(RenderingHints.KEY_RENDERING, kr);
//		/* TEST */
    }

    private static void drawIcon24(Graphics2D g2D, final Integer rn, int x, int y) {
        // Bringt nichts, weil  RenderingHints.VALUE_RENDER_QUALITY schon der Wert ist
//		/* TEST */
//		Object kr = g2D.getRenderingHint(RenderingHints.KEY_RENDERING);
//		g2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
//		/* TEST */
        int realX = x - HALF_SMALL_ICON_WIDTH;
        int realY = y - HALF_SMALL_ICON_HEIGHT;

        SMALL_ICON.paintIcon(null, g2D, realX, realY);

        Color oldColor = g2D.getColor();
        Font oldFont = g2D.getFont();
        g2D.setColor(Color.white);
        Font font = new Font("Dialog", Font.BOLD, 10);
        g2D.setFont(font);
        if (!IS_MAC) {
            if (rn < 10) {
                g2D.drawString(rn.toString(), realX + 9, realY + 11);
            } else if (rn < 100) {
                g2D.drawString(rn.toString(), realX + 7, realY + 11);
            } else {
                g2D.drawString(rn.toString(), realX + 4, realY + 11);
            }
        } else {
            if (rn < 10) {
                g2D.drawString(rn.toString(), realX + 8, realY + 11);
            } else if (rn < 100) {
                g2D.drawString(rn.toString(), realX + 5, realY + 11);
            } else {
                g2D.drawString(rn.toString(), realX + 2, realY + 11);
            }
        }
        g2D.setColor(oldColor);
        g2D.setFont(oldFont);
//		/* TEST */
//		g2D.setRenderingHint(RenderingHints.KEY_RENDERING, kr);
//		/* TEST */
    }

    @Override
    public void paintDisplayObject(final MapPane mapPane, final Graphics2D g2D, final DisplayObject displayObject, final boolean selected) {
	    if (displayObject instanceof RnDisplayObject rnDisplayObject) {
            final DOTRn dotRn = (DOTRn) rnDisplayObject.getDOTCollection().getDisplayObjectType(mapPane.getMapScale().intValue());
            if (dotRn == null) {
                return;
            }
            if (dotRn.getCategory().getOrdinal() < rnDisplayObject.getCategory().getOrdinal()) {
                return;
            }

            List<Object> coor = rnDisplayObject.getCoordinates(0);
		    if (coor.isEmpty() || !(coor.get(0) instanceof PointWithAngle pointWithAngle)) {
                return;
            }

            final Point2D point = pointWithAngle.getPoint();
            final Double xAsDouble = point.getX();
            final Double yAsDouble = point.getY();

            // Transformation
            Point2D.Double translation1 = new Point2D.Double(xAsDouble, yAsDouble);
            AffineTransform at = g2D.getTransform();
            final Point2D.Double devicePoint = new Point2D.Double();
            at.transform(translation1, devicePoint);
            // devicePoint ist nun der Punkt in Device-Koordinaten, an den der Text verschoben wird.
            RnFormat rnFormat = (RnFormat) dotRn.getValueOfStaticProperty(null, RnFormatProperty.getInstance());
            g2D.setTransform(IDENTITY);
            if (rnFormat == RnFormat.RN_BIG) {
                drawIcon32(g2D, rnDisplayObject.getRouteNumber(), (int) devicePoint.getX(), (int) devicePoint.getY());
            } else {
                drawIcon24(g2D, rnDisplayObject.getRouteNumber(), (int) devicePoint.getX(), (int) devicePoint.getY());
            }
            g2D.setTransform(at);
        }
    }

    @Nullable
    @Override
    public List<Object> getCoordinates(final List<Object> coordinates, final int type) {
        return null;
    }

    @Nullable
    @Override
    public Rectangle getBoundingRectangle(final DisplayObject displayObject, final int type) {
        // Provisorische Implementation (kopiert von DOTKmPainter)
        for (Object o : displayObject.getCoordinates(type)) {  // höchstens 1 Element
	        if (o instanceof PointWithAngle pwa) {
                return new Rectangle((int) (pwa.getPoint().getX() - 250), (int) (pwa.getPoint().getY() - 150), 500, 300);
	        } else if (o instanceof Point2D.Double p) {          // kommt in diesem Plugin derzeit nicht vor
                return new Rectangle((int) (p.getX() - 250), (int) (p.getY() - 150), 500, 300);
            }
        }
        return null;
    }
}
