/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.rnPlugin;

import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.kappich.pat.gnd.displayObjectToolkit.DOTDefinitionDialog;
import de.kappich.pat.gnd.gnd.PluginManager;
import de.kappich.pat.gnd.pluginInterfaces.DOTDefinitionPanel;
import de.kappich.pat.gnd.pluginInterfaces.DefaultDOTDefinitionPanel;
import de.kappich.pat.gnd.pluginInterfaces.DisplayObjectPainter;
import de.kappich.pat.gnd.pluginInterfaces.DisplayObjectType;
import de.kappich.pat.gnd.pluginInterfaces.DisplayObjectTypePlugin;
import de.kappich.pat.gnd.pluginInterfaces.DisplayObjectsInitializer;
import de.kappich.pat.gnd.properties.Property;
import de.kappich.pat.gnd.properties.RnFormatProperty;

/**
 * {@code DOTRnPlugin} ist die Implementation von {@link DisplayObjectTypePlugin} im Rn-Plugin.
 *
 * @author Kappich Systemberatung
 */
public class DOTRnPlugin implements DisplayObjectTypePlugin {

    private static final Debug _debug = Debug.getLogger();

    /**
     * Der Konstruktor.
     */
    public DOTRnPlugin() {
        super();
        // prüft, ob die Implementation im PluginManager bekannt ist
        if (!PluginManager.hasPlugin(getName())) {
            _debug.error("Das DOTRnPlugin ist dem PluginManager nicht bekannt.");
        }
    }

    @Override
    public final String getName() {
        return "Autobahnschilder";
    }

    @Override
    public DisplayObjectType getDisplayObjectType() {
        return new DOTRn();
    }

    @Override
    public DOTDefinitionPanel getPanel(final DOTDefinitionDialog dotDefinitionDialog) {
        return new DefaultDOTDefinitionPanel(new DOTRnPlugin(), dotDefinitionDialog);
    }

    @Override
    public DisplayObjectsInitializer getInitializer() {
        return new RnInitializer();
    }

    @Override
    public DisplayObjectPainter getPainter() {
        return new DOTRnPainter();
    }

    @Override
    public String[] getPrimitiveFormTypes() {
        return new String[0];
    }

    @Override
    public Property[] getProperties(@Nullable final Object o) {
        return new Property[] {RnFormatProperty.getInstance()};
    }

    @Override
    public String getGeometryType() {
        return "typ.äußeresStraßenSegment";
    }

    @Override
    public boolean isSystemObjectTypeSupported(final DataModel configuration, final SystemObjectType systemObjectType) {
        final SystemObjectType geoReferenceObjectType = configuration.getType(getGeometryType());
        return systemObjectType.equals(geoReferenceObjectType);
    }

    @Override
    public boolean isDynamicsPossible() {
        return false;
    }

    @Override
    public boolean isMapScaleListeningNecessary() {
        return false;
    }
}
