/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.utils.view;

import java.awt.Dimension;
import javax.swing.JTable;
import javax.swing.table.TableModel;

/**
 * Eine kleine Erweiterung von JTable.
 *
 * @author Kappich Systemberatung
 */
public class GndTable extends JTable {

    public GndTable(final TableModel tableModel) {
        super(tableModel);
    }

    public void setVisibleRowCount(int rows) {
        int height = 0;
        for (int row = 0; row < rows; row++) {
            height += getRowHeight(row);
        }

        setPreferredScrollableViewportSize(new Dimension(getPreferredScrollableViewportSize().width, height));
    }
}
