/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.utils.view;

import de.kappich.pat.gnd.gnd.PreferencesHandler;
import java.util.Objects;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.WindowConstants;

/*
 * Copyright 2017 by Kappich Systemberatung Aachen
 * ALL RIGHTS RESERVED.
 */
public class PreferencesDeleter {

    private final String _errorMessage;
    private final Preferences _preferences;

    public PreferencesDeleter(final String errorMessage, final Preferences prefs) {
        _errorMessage = errorMessage;
        _preferences = prefs;
    }

//	/**
//	 * Öffnet einen OptionDialog. Gibt <code>true</code> zurück, wenn alle Präferenzen gelöscht wurden.
//	 *
//	 * @return
//	 */
//	public boolean run() {
//		Object[] options = {"Trotzdem weitermachen", "Alle Präferenzen löschen und Programm beenden"};
//		int option = JOptionPane.showOptionDialog(
//				null,
//				_errorMessage,
//				"Fehlermeldung",
//				JOptionPane.DEFAULT_OPTION,
//				JOptionPane.INFORMATION_MESSAGE,
//				null,
//				options,
//				options[0]
//		);
//		if(0 == option) {
//			JOptionPane.showConfirmDialog(
//					null,
//					"Es kann jederzeit zu Abstürzen kommen.",
//					"Warnung",
//					JOptionPane.OK_OPTION,
//					JOptionPane.WARNING_MESSAGE
//			);
//		}
//		else if(1 == option) {
//			Preferences gndPrefs = PreferencesHandler.getInstance().getPreferenceStartPath();
//			try {
//				gndPrefs.removeNode();
//				return true;
//			}
//			catch(BackingStoreException ignore) {
//				JOptionPane.showMessageDialog(
//						null,
//						"Das Löschen war nicht erfolgreich.",
//						"Fehlermeldung",
//						JOptionPane.ERROR_MESSAGE
//				);
//			}
//		}
//		return false;
//	}

    /**
     * Öffnet einen modalen Dialog.
     */
    public void run() {
        // Diese Implementation verhindert, dass der Benutzer den Dialog einfach schließt. Gebaut nach
        // https://docs.oracle.com/javase/tutorial/uiswing/components/dialog.html#stayup
        // siehe "Stopping Automatic Dialog Closing"
        String message = _errorMessage;
        if (_preferences != null) {
            message += System.lineSeparator() + "(Siehe Präferenzen unter: " + _preferences.absolutePath() + ")";
        }
        Object[] options = {"Trotzdem weitermachen", "Alle Präferenzen löschen und Programm beenden"};
        final JOptionPane optionPane = new JOptionPane(message, JOptionPane.ERROR_MESSAGE, JOptionPane.DEFAULT_OPTION, null, options, options[0]);
        final JDialog dialog = new JDialog(JOptionPane.getRootFrame(), "Fehler", true);
        dialog.setContentPane(optionPane);
        dialog.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
        optionPane.addPropertyChangeListener(e -> {
            String prop = e.getPropertyName();

            if (dialog.isVisible() && Objects.equals(e.getSource(), optionPane) && prop.equals(JOptionPane.VALUE_PROPERTY)) {
                //If you were going to check something
                //before closing the window, you'd do
                //it here.
                dialog.setVisible(false);
            }
        });
        dialog.pack();
        dialog.setLocationRelativeTo(JOptionPane.getRootFrame());
        dialog.setVisible(true);

        String option = (String) optionPane.getValue();
        if (options[0] == option) {
            JOptionPane.showMessageDialog(null, "Es kann jederzeit zum Absturz kommen.", "Warnung", JOptionPane.WARNING_MESSAGE, null);
        } else if (options[1] == option) {
            Preferences gndPrefs = PreferencesHandler.getInstance().getPreferenceStartPath();
            try {
                gndPrefs.removeNode();
                System.exit(0);
            } catch (BackingStoreException ignore) {
                JOptionPane.showMessageDialog(null, "Das Löschen war nicht erfolgreich.", "Fehlermeldung", JOptionPane.ERROR_MESSAGE);
            }
        }
    }
}
