/*
 * Copyright 2011-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.viewManagement;

import de.kappich.pat.gnd.layerManagement.Layer;
import de.kappich.pat.gnd.needlePlugin.DOTNeedle;

/**
 * @author Kappich Systemberatung
 */
public final class NoticeViewEntry extends ViewEntry {

    private final ViewEntry _viewEntry;

    private NoticeViewEntry(final ViewEntry viewEntry, Layer layer, int zoomIn, int zoomOut, boolean visible) {
        super(layer, zoomIn, zoomOut, false, visible);
        _viewEntry = viewEntry;
    }

    public static NoticeViewEntry create(final ViewEntry viewEntry) {
        return new NoticeViewEntry(viewEntry, makeNoticeLayer(viewEntry.getLayer()), viewEntry.getZoomIn(), viewEntry.getZoomOut(),
                                   viewEntry.isVisible());
    }

    private static Layer makeNoticeLayer(final Layer layer) {
        NoticeLayer noticeLayer = new NoticeLayer(layer);
        DOTNeedle type = new DOTNeedle("Notiz", "Stellt Notizen dar.");
        noticeLayer.addDisplayObjectType(type, Integer.MAX_VALUE, 1);
        return noticeLayer;
    }

    @Override
    public boolean isVisible() {
        return _viewEntry.isVisible();
    }

    @Override
    public boolean isVisible(final int scale) {
        return _viewEntry.isVisible(scale);
    }

    @Override
    public String toString() {
        return "NoticeViewEntry{" + "_viewEntry=" + _viewEntry + '}';
    }
}
