/*
 * Copyright 2004 by Kappich+Kniß Systemberatung, Aachen
 * Copyright 2007-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.configBrowser.
 *
 * de.kappich.pat.configBrowser is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.configBrowser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.configBrowser.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.configBrowser.main;

import de.bsvrz.dav.daf.main.config.DataModel;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;

/**
 * Realisiert ein Swing-JPanel zur Darstellung der Konfigurationsobjekte.
 *
 * @author Kappich Systemberatung
*/
public class DataModelTreePanel extends JPanel {

    private JTree _tree;

    public DataModelTreePanel(DataModel dm) {
        _tree = new JTree(new DataModelTreeModel(dm));
        JScrollPane scrollPane = new JScrollPane(_tree);
        setLayout(new java.awt.BorderLayout());
        _tree.setShowsRootHandles(true);
        add(scrollPane, java.awt.BorderLayout.CENTER);
    }

    public static JFrame showTreeFrame(DataModel dm) {
        JFrame frame = new JFrame("Datenmodell");
        frame.getContentPane().add("Center", new DataModelTreePanel(dm));
        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });

        int w = 400;
        int h = 600;
        frame.setSize(w, h);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(screenSize.width / 3 - w / 2, screenSize.height / 2 - h / 2);
        frame.setVisible(true);
        return frame;
    }
//    public static void main(String[] args) {
//        String xmlFileName="e:\\datenmodell\\meta.xml";
//        if(args.length>1) throw new Error("Zu viele Argumente");
//        if(args.length==1) xmlFileName= args[0];
//        DataModel dm= null;
//        try {
//            dm= new XmlDataModel(xmlFileName);
//        }
//        catch(Exception e) {
//            System.err.println("Datenmodell konnte nicht erzeugt werden");
//            return;
//        }
//        JFrame frame = new JFrame("Datenmodell");
//
//		frame.getContentPane().add("Center", new DataModelTreePanel(dm) );
//
//        frame.addWindowListener(new WindowAdapter() {
//            public void windowClosing(WindowEvent e) {
//                System.exit(0);
//            }
//        });
//
//		int w = 400;
//		int h = 600;
//		frame.setSize(w, h);
//		Dimension screenSize= Toolkit.getDefaultToolkit().getScreenSize();
//		frame.setLocation(screenSize.width/3 - w/2, screenSize.height/2 - h/2);
//        frame.show();
//    }

}
