/*
 * Copyright 2019-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.daf.
 *
 * de.bsvrz.dav.daf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.daf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.dav.daf; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.dav.daf.accessControl;

import java.util.EventListener;

/**
 * Listener, der bei Änderungen von Nutzerrechten ausgeführt wird
 *
 * @author Kappich Systemberatung
 * @see UserInfo#addChangeListener(AccessControlChangeListener)
 * @see AccessControlManager#addChangeListener(AccessControlChangeListener)
 */
@FunctionalInterface
public interface AccessControlChangeListener extends EventListener {

    /**
     * Wird aufgerufen, wenn sich die Berechtigungen einen Benutzers (potentiell) geändert haben, beispielsweise durch eine geänderte Parametrierung
     * oder weil sich Objektmengen geändert haben.
     * <p>Nachdem diese Methode aufgerufen wurde, muss der Nutzer der Klasse ggf. feststellen, welche Anmeldungen aktuell bestehen und neu verboten
     * werden müssen, bzw. welche bisher verbotenen Anmeldungen nun erlaubt sind.</p>
     * <p>Das Rechte-Management-Framework in den DAF-Funktionen bemüht sich, diese Methode nur einmal aufzurufen, selbst wenn sich mehrere Rechte
     * eines Nutzers geändert haben.</p>
     *
     * @param user Benutzer, dessen Rechte sich geändert haben
     */
    void userPermissionsChanged(UserInfo user);

}
