/*
 * Copyright 2019-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.daf.
 *
 * de.bsvrz.dav.daf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.daf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.dav.daf; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.dav.daf.accessControl.internal;

import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import java.util.Collection;
import java.util.List;

/**
 * @author Kappich Systemberatung
 */
public interface ObjectCollection {

    /**
     * Alle Objekte, die durch diesen Block ausgewählt werden
     *
     * @param types Systemobjekttypen die beachtet werden sollen
     *
     * @return Alle Objekte, die durch diesen Block ausgewählt werden
     */
    List<SystemObject> getAllObjects(Collection<? extends SystemObjectType> types);

    /**
     * Startet alle Listener
     *
     * @param listener
     */
    void addChangeListener(final ObjectCollectionChangeListener listener);

    /**
     * Stoppt alle Listener
     *
     * @param listener
     */
    void removeChangeListener(final ObjectCollectionChangeListener listener);
}
