/*
 * Copyright 2019-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.daf.
 *
 * de.bsvrz.dav.daf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.daf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.dav.daf; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.dav.daf.accessControl.internal;

import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import java.util.Collection;

/**
 * Kapselt einen Block wie "AuswahlBereich", "AuswahlObjekte" etc. Entspricht aber nicht direkt den DatenmodellBlöcken, da je nach gesetzten
 * Parametern optimierte Klassen benutzt werden
 *
 * @author Kappich Systemberatung
 * @version $Revision: 0000 $
 */
public interface ObjectSelectionBlock {

    /**
     * Prüft ob das übergebene Objekt in diesem Block enthalten ist
     *
     * @param object Testobjekt
     *
     * @return true wenn enthalten
     */
    boolean contains(SystemObject object);

    /**
     * Gibt alle Objekte in dem Block zurück. Der Aufruf sollte, falls möglich, vermieden werden, da der Vorgang je nach Definition sehr lange dauern
     * kann
     *
     * @param type Liste mit Systemobjekttypen die beachtet werden sollen.
     *
     * @return Liste mit Systemobjekten
     */
    Collection<SystemObject> getAllObjects(final Collection<? extends SystemObjectType> type);

    /**
     * Gibt alle Objekttypen zurück, die in diesem Block betrachtet werden, bzw. nach denen gefiltert wird. Alle mit {@link
     * #getAllObjects(java.util.Collection)} zurückgelieferten Objekte sind zwingend von diesen Typen, umgekehrt ist allerdings nicht sichergestellt,
     * dass zu allen hier zurückgelieferten Typen auch Objekte vorhanden sind.
     *
     * @return Liste mit allen Typen
     */
    Collection<SystemObjectType> getAllObjectTypes();

    /**
     * Erstellt einen Listener, der Objekte über das Ändern dieses Blocks benachrichtigt
     *
     * @param object Listener
     */
    void addChangeListener(ObjectCollectionChangeListener object);

    /**
     * Entfernt einen Listener, der Objekte über das Ändern dieses Blocks benachrichtigt
     *
     * @param object Listener
     */
    void removeChangeListener(ObjectCollectionChangeListener object);

    /**
     * Markiert das Objekt als unbenutzt, sodass angemeldete Listener etc. abgemeldet werden können
     */
    void dispose();
}
