/*
 * Copyright 2019-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.daf.
 *
 * de.bsvrz.dav.daf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.daf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.dav.daf; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.dav.daf.accessControl.internal;

/**
 * Listener-Interface das für die Benachrichtigung über Änderungen der Liste der ausgewählten Objekte in Regionen benutzt wird. Die ausgewählten
 * Objekte in Regionen können sich z.B. ändern, wenn ein neues Dynamisches Objekt angelegt wird, eine dynamische Menge sich ändert, oder die
 * Definition der Region geändert wird
 *
 * @author Kappich Systemberatung
 * @version $Revision: 0000 $
 */
public interface RegionChangeListener {

    /**
     * Wird aufgerufen, wenn sich eine Region geändert hat
     *
     * @param region Region, die sich geändert hat
     */
    void regionChanged(Region region);
}
