/*
 * Copyright 2004 by Kappich+Kniß Systemberatung, Aachen
 * Copyright 2007-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.daf.
 *
 * de.bsvrz.dav.daf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.daf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.dav.daf; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.dav.daf.communication.dataRepresentation.datavalue;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/**
 * Diese Klasse stellt die Attribute und Funktionalitäten des Datentyps float zur Verfügung.
 *
 * @author Kappich Systemberatung
 */
public class FloatAttribute extends DataValue {

    /** Der Floatwert */
    private float _float;

    /** Erzeugt ein neues Objekt ohne Parameter. Die Parameter werden zu einem Späteren Zeitpunkt über die read-Methode eingelesen. */
    public FloatAttribute() {
        _type = FLOAT_TYPE;
    }

    /**
     * Erzeugt ein neues Objekt mit den gegebenen Parametern.
     *
     * @param f float Wert
     */
    public FloatAttribute(float f) {
        _type = FLOAT_TYPE;
        _float = f;
    }

    @Override
    public final Object getValue() {
        return _float;
    }

    @Override
    public final DataValue cloneObject() {
        return new FloatAttribute(_float);
    }

    @Override
    public final String parseToString() {
        return "Float: " + _float + "\n";
    }

    @Override
    public final void write(DataOutputStream out) throws IOException {
        out.writeFloat(_float);
    }

    @Override
    public final void read(DataInputStream in) throws IOException {
        _float = in.readFloat();
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final FloatAttribute that = (FloatAttribute) o;

        return Float.compare(that._float, _float) == 0;
    }

    @Override
    public int hashCode() {
        return _float != 0.0f ? Float.floatToIntBits(_float) : 0;
    }
}
