/*
 * Copyright 2004 by Kappich+Kniß Systemberatung, Aachen
 * Copyright 2007-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.daf.
 *
 * de.bsvrz.dav.daf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.daf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.dav.daf; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.dav.daf.communication.dataRepresentation.datavalue;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

/**
 * Diese Klasse stellt die Attribute und Funktionalitäten des Datentyps LongArray zur Verfügung.
 *
 * @author Kappich Systemberatung
 */
public class LongArrayAttribute extends DataValue {

    /** Der Long Array Wert */
    private long[] _longArray;

    /** Erzeugt ein neues Objekt ohne Parameter. Die Parameter werden zu einem Späteren Zeitpunkt über die read-Methode eingelesen. */
    public LongArrayAttribute() {
        _type = LONG_ARRAY_TYPE;
    }

    /**
     * Erzeugt ein neues Objekt mit den gegebenen Parametern.
     *
     * @param longArray Feld mit long Werten
     */
    public LongArrayAttribute(long[] longArray) {
        _type = LONG_ARRAY_TYPE;
        _longArray = longArray;
    }

    @Override
    public final Object getValue() {
        return _longArray;
    }

    @Override
    public final DataValue cloneObject() {
        return new LongArrayAttribute(_longArray == null ? null : _longArray.clone());
    }

    @Override
    public final String parseToString() {
        StringBuilder str = new StringBuilder("Long Array  : [ ");
        if (_longArray != null) {
            for (int i = 0; i < _longArray.length; ++i) {
                if (i == 0) {
                    str.append(_longArray[i]);
                } else {
                    str.append(" , ").append(_longArray[i]);
                }
            }
        }
        str.append(" ]\n");
        return str.toString();
    }

    @Override
    public final void write(DataOutputStream out) throws IOException {
        if (_longArray == null) {
            out.writeInt(0);
        } else {
            out.writeInt(_longArray.length);
            for (final long a_longArray : _longArray) {
                out.writeLong(a_longArray);
            }
        }
    }

    @Override
    public final void read(DataInputStream in) throws IOException {
        int length = in.readInt();
        if (length >= 0) {
            _longArray = new long[length];
            for (int i = 0; i < length; ++i) {
                _longArray[i] = in.readLong();
            }
        }
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final LongArrayAttribute that = (LongArrayAttribute) o;

        return Arrays.equals(_longArray, that._longArray);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(_longArray);
    }
}
