/*
 * Copyright 2004 by Kappich+Kniß Systemberatung, Aachen
 * Copyright 2007-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.daf.
 *
 * de.bsvrz.dav.daf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.daf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.dav.daf; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.dav.daf.communication.dataRepresentation.datavalue;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/**
 * Diese Klasse stellt die Attribute und Funktionalitäten des Datentyps long zur Verfügung.
 *
 * @author Kappich Systemberatung
 */
public class LongAttribute extends DataValue {

    /** Der Longwert */
    private long _long;

    /** Erzeugt ein neues Objekt ohne Parameter. Die Parameter werden zu einem Späteren Zeitpunkt über die read-Methode eingelesen. */
    public LongAttribute() {
        _type = LONG_TYPE;
    }

    /**
     * Erzeugt ein neues Objekt mit den gegebenen Parametern.
     *
     * @param l long wert
     */
    public LongAttribute(long l) {
        _type = LONG_TYPE;
        _long = l;
    }

    @Override
    public final Object getValue() {
        return _long;
    }

    protected long getPlainValue() {
        return _long;
    }

    @Override
    public DataValue cloneObject() {
        return new LongAttribute(_long);
    }

    @Override
    public final String parseToString() {
        return "Long: " + _long + "\n";
    }

    @Override
    public final void write(DataOutputStream out) throws IOException {
        out.writeLong(_long);
    }

    @Override
    public final void read(DataInputStream in) throws IOException {
        _long = in.readLong();
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final LongAttribute that = (LongAttribute) o;

        return _long == that._long;
    }

    @Override
    public int hashCode() {
	    return Long.hashCode(_long);
    }
}
