/*
 * Copyright 2004 by Kappich+Kniß Systemberatung, Aachen
 * Copyright 2007-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.daf.
 *
 * de.bsvrz.dav.daf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.daf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.dav.daf; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.dav.daf.communication.dataRepresentation.datavalue;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

/**
 * Diese Klasse stellt die Attribute und Funktionalitäten des Datentyps ShortArray zur Verfügung.
 *
 * @author Kappich Systemberatung
 */
public class ShortArrayAttribute extends DataValue {

    /** Der Short Array Wert */
    private short[] _shortArray;

    /** Erzeugt ein neues Objekt ohne Parameter. Die Parameter werden zu einem Späteren Zeitpunkt über die read-Methode eingelesen. */
    public ShortArrayAttribute() {
        _type = SHORT_ARRAY_TYPE;
    }

    /**
     * Erzeugt ein neues Objekt mit den gegebenen Parametern.
     *
     * @param shortArray Feld mit short Werten
     */
    public ShortArrayAttribute(short[] shortArray) {
        _type = SHORT_ARRAY_TYPE;
        _shortArray = shortArray;
    }

    @Override
    public final Object getValue() {
        return _shortArray;
    }

    @Override
    public final DataValue cloneObject() {
        return new ShortArrayAttribute(_shortArray == null ? null : _shortArray.clone());
    }

    @Override
    public final String parseToString() {
        StringBuilder str = new StringBuilder("Short Array  : [ ");
        if (_shortArray != null) {
            for (int i = 0; i < _shortArray.length; ++i) {
                if (i == 0) {
                    str.append(_shortArray[i]);
                } else {
                    str.append(" , ").append(_shortArray[i]);
                }
            }
        }
        str.append(" ]\n");
        return str.toString();
    }

    @Override
    public final void write(DataOutputStream out) throws IOException {
        if (_shortArray == null) {
            out.writeInt(0);
        } else {
            out.writeInt(_shortArray.length);
            for (final short a_shortArray : _shortArray) {
                out.writeShort(a_shortArray);
            }
        }
    }

    @Override
    public final void read(DataInputStream in) throws IOException {
        int length = in.readInt();
        if (length >= 0) {
            _shortArray = new short[length];
            for (int i = 0; i < length; ++i) {
                _shortArray[i] = in.readShort();
            }
        }
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final ShortArrayAttribute that = (ShortArrayAttribute) o;

        return Arrays.equals(_shortArray, that._shortArray);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(_shortArray);
    }
}
