/*
 * Copyright 2004 by Kappich+Kniß Systemberatung, Aachen
 * Copyright 2007-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.daf.
 *
 * de.bsvrz.dav.daf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.daf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.dav.daf; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.dav.daf.communication.dataRepresentation.datavalue;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/**
 * Diese Klasse stellt die Attribute und Funktionalitäten des Datentyps short zur Verfügung.
 *
 * @author Kappich Systemberatung
 */
public class ShortAttribute extends DataValue {

    /** Der Shortwert */
    private short _short;

    /** Erzeugt ein neues Objekt ohne Parameter. Die Parameter werden zu einem Späteren Zeitpunkt über die read-Methode eingelesen. */
    public ShortAttribute() {
        _type = SHORT_TYPE;
    }

    /**
     * Erzeugt ein neues Objekt mit den gegebenen Parametern.
     *
     * @param s short Wert
     */
    public ShortAttribute(short s) {
        _type = SHORT_TYPE;
        _short = s;
    }

    @Override
    public final Object getValue() {
        return _short;
    }

    @Override
    public final DataValue cloneObject() {
        return new ShortAttribute(_short);
    }

    @Override
    public final String parseToString() {
        return "Short: " + _short + "\n";
    }

    @Override
    public final void write(DataOutputStream out) throws IOException {
        out.writeShort(_short);
    }

    @Override
    public final void read(DataInputStream in) throws IOException {
        _short = in.readShort();
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final ShortAttribute that = (ShortAttribute) o;

        return _short == that._short;
    }

    @Override
    public int hashCode() {
        return (int) _short;
    }
}
