/*
 * Copyright 2004 by Kappich+Kniß Systemberatung, Aachen
 * Copyright 2007-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.daf.
 *
 * de.bsvrz.dav.daf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.daf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.dav.daf; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.dav.daf.communication.dataRepresentation.datavalue;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

/**
 * Diese Klasse stellt die Attribute und Funktionalitäten des Datentyps StringArray zur Verfügung.
 *
 * @author Kappich Systemberatung
 */
public class StringArrayAttribute extends DataValue {

    /** Der String Array Wert */
    private String[] _stringArray;

    /** Erzeugt ein neues Objekt ohne Parameter. Die Parameter werden zu einem Späteren Zeitpunkt über die read-Methode eingelesen. */
    public StringArrayAttribute() {
        _type = STRING_ARRAY_TYPE;
    }

    /**
     * Erzeugt ein neues Objekt mit den gegebenen Parametern.
     *
     * @param stringArray Feld mit Strings
     */
    public StringArrayAttribute(String[] stringArray) {
        _type = STRING_ARRAY_TYPE;
        _stringArray = stringArray;
    }

    @Override
    public final Object getValue() {
        return _stringArray;
    }

    @Override
    public final DataValue cloneObject() {
        return new StringArrayAttribute(_stringArray == null ? null : _stringArray.clone());
    }

    @Override
    public final String parseToString() {
        StringBuilder str = new StringBuilder("String Array  : [ ");
        if (_stringArray != null) {
            for (int i = 0; i < _stringArray.length; ++i) {
                if (i == 0) {
                    str.append(_stringArray[i]);
                } else {
                    str.append(" , ").append(_stringArray[i]);
                }
            }
        }
        str.append(" ]\n");
        return str.toString();
    }

    @Override
    public final void write(DataOutputStream out) throws IOException {
        if (_stringArray == null) {
            out.writeInt(0);
        } else {
            out.writeInt(_stringArray.length);
            for (final String a_stringArray : _stringArray) {
                out.writeUTF(a_stringArray);
            }
        }
    }

    @Override
    public final void read(DataInputStream in) throws IOException {
        int length = in.readInt();
        if (length >= 0) {
            _stringArray = new String[length];
            for (int i = 0; i < length; ++i) {
                _stringArray[i] = in.readUTF();
            }
        }
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final StringArrayAttribute that = (StringArrayAttribute) o;

        return Arrays.equals(_stringArray, that._stringArray);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(_stringArray);
    }
}
