/*
 * Copyright 2018-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.daf.
 *
 * de.bsvrz.dav.daf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.daf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.dav.daf; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.dav.daf.main;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

/**
 * Implementierung eines Iterators über ein Objekt vom Typ {@link Data.Array}.
 *
 * @author Kappich Systemberatung
 */
public class ArrayIterator implements Iterator<Data> {
    private final Data.Array _array;
    private int _nextIndex;

    /**
     * Erstellt einen neuen ArrayIterator
     *
     * @param array Array, über das iteriert werden soll
     */
    public ArrayIterator(final Data.Array array) {
        _array = Objects.requireNonNull(array);
    }

    @Override
    public boolean hasNext() {
        return _nextIndex < _array.getLength();
    }

    @Override
    public Data next() {
        if (!hasNext()) {
            throw new NoSuchElementException();
        }
        Data result = _array.getItem(_nextIndex);
        _nextIndex++;
        return result;
    }
}
