/*
 * Copyright 2019-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.daf.
 *
 * de.bsvrz.dav.daf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.daf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.dav.daf; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.dav.daf.main.authentication;

import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

/**
 * Interaktive Authentifizierung, wie {@link InteractiveAuthentication}, nur in einem Swing-Fenster statt über Konsole.
 *
 * @author Kappich Systemberatung
 * @since 3.14
 */
public class InteractiveGuiAuthentication implements UserProperties {

    private final Component _parentComponent;

    public InteractiveGuiAuthentication(@Nullable final Component parentComponent) {
        _parentComponent = parentComponent;
    }

    public static InteractiveGuiAuthentication getInstance(@Nullable final Component parentComponent) {
        return new InteractiveGuiAuthentication(parentComponent);
    }

    @Nullable
    @Override
    public ClientCredentials getClientCredentials(final String userName, final String suffix) {
        JPasswordField passwordField = new JPasswordField();
        JLabel label = new JLabel("Passwort:");
        label.setLabelFor(passwordField);
        JPanel panel = new JPanel(new BorderLayout(16, 16));
        panel.add(label, BorderLayout.LINE_START);
        panel.add(passwordField, BorderLayout.CENTER);
        JPanel rootPanel = new JPanel();
        rootPanel.setLayout(new BoxLayout(rootPanel, BoxLayout.PAGE_AXIS));
        rootPanel.add(Box.createVerticalGlue());
        rootPanel.add(panel);
        rootPanel.add(Box.createVerticalGlue());
        int dialog = JOptionPane
            .showConfirmDialog(_parentComponent, rootPanel, "Passwort für \"" + userName + "\"" + (suffix == null ? "" : "@" + suffix),
                               JOptionPane.OK_CANCEL_OPTION, JOptionPane.PLAIN_MESSAGE);

        if (dialog == JOptionPane.OK_OPTION) {
            return ClientCredentials.ofPassword(passwordField.getPassword());
        }
        return null;
    }

    @Nullable
    @Override
    public ClientCredentials getClientCredentials(final String userName) {
        return getClientCredentials(userName, null);
    }
}
