/*
 * Copyright 2005 by Kappich+Kniß Systemberatung Aachen (K2S)
 * Copyright 2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.daf.
 *
 * de.bsvrz.dav.daf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.daf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.dav.daf; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.dav.daf.main.config;

/**
 * Konfigurationsausnahmen signalisieren Fehler bei Konfigurationsänderungen. Sie können von allen Methoden, die Änderungen an der Konfiguration
 * durchführen, erzeugt werden.
 *
 * @author Kappich+Kniß Systemberatung Aachen (K2S)
 * @author Stephan Homeyer (sth)
 * @version $Revision$ / $Date$ / ($Author$)
 */
public class ConfigurationChangeException extends ConfigurationTaskException {
    /**
     * Erzeugt eine neue Konfigurationsausnahme ohne Detailmeldung.
     */
    public ConfigurationChangeException() {
    }

    /**
     * Erzeugt eine neue Konfigurationsausnahme mit der spezifizierten Detailmeldung.
     *
     * @param message Detailmeldung der neuen Konfigurationsausnahme.
     */
    public ConfigurationChangeException(String message) {
        super(message);
    }

    public ConfigurationChangeException(String message, Throwable cause) {
        super(message, cause);
    }

    public ConfigurationChangeException(Throwable cause) {
        super(cause);
    }
}
