/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.pat.sysbed.
 *
 * de.bsvrz.pat.sysbed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.pat.sysbed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.pat.sysbed.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.pat.sysbed.help;

import de.bsvrz.sys.funclib.kappich.onlinehelp.Help;
import de.bsvrz.sys.funclib.kappich.onlinehelp.HelpPage;
import de.bsvrz.sys.funclib.kappich.onlinehelp.SearchFrame;
import javax.swing.JEditorPane;

/**
 * Diese Klasse bietet nur eine statische Methode zum Öffnen des Hilfedialogs.
 *
 * @author Kappich Systemberatung
 */
public class GtmHelp implements Help {

    /**
     * Aus Bequemlichkeitsgründen ist die statische Methode auch {@code public}.
     *
     * @param href eine Hypertext-Referenz
     */
    public static void openHelp(final String href) {
        JEditorPane helpPane = HelpPage.getHelpPane(GtmHelp.class, "beschreibung.html", href);
        if (helpPane != null) {
            final SearchFrame searchFrame = new SearchFrame(helpPane, null);
            searchFrame.setTitle("Bedienungsanleitung");
            searchFrame.setSize(950, 800);
            searchFrame.setLocationRelativeTo(null);
            searchFrame.setVisible(true);
        }
    }

    /**
     * Öffnet einen GTM-Hilfedialog/Bedienungsanleitung an der durch {@code href} angegbenen Stelle.
     *
     * @param href eine Hypertext-Referenz
     */
    @Override
    public void open(final String href) {
        openHelp(href);
    }
}
