/*
 * Copyright 2019-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.pat.sysbed.
 *
 * de.bsvrz.pat.sysbed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.pat.sysbed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.pat.sysbed.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.pat.sysbed.permissions;

import de.bsvrz.dav.daf.accessControl.UserInfo;
import de.bsvrz.dav.daf.accessControl.internal.UserAction;
import de.bsvrz.dav.daf.main.config.AttributeGroupUsage;
import de.bsvrz.dav.daf.main.config.SystemObject;

/**
 * Ein Zustand der Rechteprüfugn zur Visualisierung
 *
 * @author Kappich Systemberatung
 */
public class PermissionsState {

    private InnerState _sender;
    private InnerState _receiver;
    private InnerState _source;
    private InnerState _drain;

    public PermissionsState(final UserInfo userPermissions, final SystemObject obj, final AttributeGroupUsage usage) {

        _sender = mapState(userPermissions.maySubscribeData(obj, usage.getAttributeGroup(), usage.getAspect(), UserAction.SENDER));
        _receiver = mapState(userPermissions.maySubscribeData(obj, usage.getAttributeGroup(), usage.getAspect(), UserAction.RECEIVER));
        _source = mapState(userPermissions.maySubscribeData(obj, usage.getAttributeGroup(), usage.getAspect(), UserAction.SOURCE));
        _drain = mapState(userPermissions.maySubscribeData(obj, usage.getAttributeGroup(), usage.getAspect(), UserAction.DRAIN));

        switch (usage.getUsage()) {
            case OnlineDataAsSenderDrain:
                if (_receiver == InnerState.Allowed) {
                    _receiver = InnerState.AllowedWrongUsage;
                } else {
                    _receiver = InnerState.Ignore;
                }
                if (_source == InnerState.Allowed) {
                    _source = InnerState.AllowedWrongUsage;
                } else {
                    _source = InnerState.Ignore;
                }
                break;
            case OnlineDataAsSourceReceiverOrSenderDrain:
                if (_sender == InnerState.Allowed) {
                    _sender = InnerState.AllowedWrongUsage;
                } else {
                    _sender = InnerState.Ignore;
                }
                if (_drain == InnerState.Allowed) {
                    _drain = InnerState.AllowedWrongUsage;
                } else {
                    _drain = InnerState.Ignore;
                }
                break;
        }

    }

    private static InnerState mapState(final boolean maySubscribeData) {
        return maySubscribeData ? InnerState.Allowed : InnerState.Forbidden;
    }

    public InnerState getSender() {
        return _sender;
    }

    public InnerState getReceiver() {
        return _receiver;
    }

    public InnerState getSource() {
        return _source;
    }

    public InnerState getDrain() {
        return _drain;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
	    if (!(o instanceof PermissionsState that)) {
            return false;
        }

        if (_sender != that._sender) {
            return false;
        }
        if (_receiver != that._receiver) {
            return false;
        }
        if (_source != that._source) {
            return false;
        }
        return _drain == that._drain;
    }

    @Override
    public int hashCode() {
        int result = _sender.hashCode();
        result = 31 * result + _receiver.hashCode();
        result = 31 * result + _source.hashCode();
        result = 31 * result + _drain.hashCode();
        return result;
    }

    public enum InnerState {

        Allowed, Forbidden, AllowedWrongUsage, Ignore,

    }
}
