/*
 * Copyright 2018-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.pat.sysbed.
 *
 * de.bsvrz.pat.sysbed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.pat.sysbed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.pat.sysbed.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.pat.sysbed.plugins.archiveinfo;

import de.bsvrz.dav.daf.main.archive.ArchiveDataSpecification;
import de.bsvrz.dav.daf.main.archive.ArchiveInfoQueryResult;
import de.bsvrz.dav.daf.main.archive.ArchiveInformationResult;
import de.bsvrz.dav.daf.main.archive.ArchiveRequestManager;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.pat.sysbed.plugins.api.ExternalModuleAdapter;
import de.bsvrz.pat.sysbed.plugins.api.settings.SettingsData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.SwingUtilities;

/**
 * PlugIn-Modul für Archivinformationsanfragen
 *
 * @author Kappich Systemberatung
 */
public class ArchiveInfoModule extends ExternalModuleAdapter {
    @Override
    public String getModuleName() {
        return "Archiv-Informationsanfragen";
    }

    @Override
    public String getButtonText() {
        return "Archiv-Information";
    }

    @Override
    public String getTooltipText() {
        return "";
    }

    @Override
    public void startModule(final SettingsData settingsData) {
        openSettings(new ArchiveInfoSettings(this, settingsData));
    }

    @Override
    public void startSettings(final SettingsData settingsData) {
        startQuery(new ArchiveInfoSettings(this, settingsData));
    }

    @Override
    public void change(final SettingsData settingsData) {
        openSettings(new ArchiveInfoSettings(this, settingsData));
    }

    private void openSettings(final ArchiveInfoSettings archiveInfoSettings) {
        ArchiveInfoSettingsDialog dialog = new ArchiveInfoSettingsDialog(this, getApplication().getParent(), archiveInfoSettings);
        dialog.setVisible(true);
    }

    private void startQuery(final ArchiveInfoSettings archiveInfoSettings) {
        String archivePid = archiveInfoSettings.getArchive();
        DataModel dataModel = getConnection().getDataModel();
        SystemObject archive = archivePid.isEmpty() ? getConnection().getLocalConfigurationAuthority() : dataModel.getObject(archivePid);
        ArchiveRequestManager requestManager = getConnection().getArchive(archive);
        ArchiveInfoRequester archiveInfoTask = new ArchiveInfoRequester(getApplication().getParent(), requestManager);
        new Thread(() -> {
            List<ArchiveDataSpecification> dataSpecifications = archiveInfoSettings.getDataSpecifications();
            ArchiveInfoQueryResult result = archiveInfoTask.execute(manager -> manager.requestInfo(dataSpecifications));
            if (result == null) {
                return;
            }
            List<ArchiveInformationResult> archiveInfoQueryResult = result.getArchiveInfoQueryResult();
            LinkedHashMap<ArchiveDataSpecification, List<ArchiveInformationResult>> map = new LinkedHashMap<>();
            for (ArchiveDataSpecification dataSpecification : dataSpecifications) {
                map.put(dataSpecification, new ArrayList<>());
            }
            for (ArchiveInformationResult informationResult : archiveInfoQueryResult) {
                map.get(informationResult.getArchiveDataSpecification()).add(informationResult);
            }
            SwingUtilities.invokeLater(() -> new ArchiveInfoResultDialog(archiveInfoTask, map, archivePid, getApplication()).setVisible(true));
        }).start();

    }
}
