/*
 * Copyright 2011-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.pat.sysbed.
 *
 * de.bsvrz.pat.sysbed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.pat.sysbed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.pat.sysbed.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.pat.sysbed.plugins.subscriptions;

import de.bsvrz.dav.daf.main.ClientDavConnection;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.ClientApplication;
import de.bsvrz.dav.daf.main.config.DavApplication;
import de.bsvrz.dav.daf.main.config.Pid;
import de.bsvrz.dav.daf.main.config.SystemObject;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.WindowConstants;

/**
 * @author Kappich Systemberatung
 * @version $Revision: 11390 $
 */
public class AppSubscriptionInfoFrame extends JFrame {

    private final JComboBox<Object> _davObjSelection;

    private final Container _pane;

    private final ClientDavInterface _connection;

    private final ClientApplication _application;
    private final JCheckBox _compressedViewCheckbox;
    private JPanel _subscriptionsPanel;

    public AppSubscriptionInfoFrame(final ClientDavInterface connection, final ClientApplication application) {
        _connection = connection;
        _application = application;

        setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Anmeldungsinfo");

        _pane = getContentPane();
        _pane.setLayout(new BorderLayout());
        DavApplication dav = _application.getDavApplication();

        if (dav == null) {
            dav = _connection.getLocalDav();
        }

        _pane.add(getHeaderPanel(_application), BorderLayout.NORTH);
        _subscriptionsPanel = new AppSubscriptionsPanel((ClientDavConnection) _connection, _application, dav);
        _pane.add(_subscriptionsPanel, BorderLayout.CENTER);

        final JButton refreshButton = new JButton("Aktualisieren");
        refreshButton.addActionListener(new RefreshListener());
        _compressedViewCheckbox = new JCheckBox("Komprimierte Darstellung");
        _compressedViewCheckbox.addActionListener(new RefreshListener());
        List<SystemObject> davObjects = _connection.getDataModel().getType(Pid.Type.DAV_APPLICATION).getObjects();
        Object[] objects = davObjects.toArray(new Object[0]);
        Arrays.sort(objects);
        _davObjSelection = new JComboBox<>(objects);
        _davObjSelection.setEditable(false);
        _davObjSelection.setSelectedItem(dav);

        final JPanel outerPanel = new JPanel();
        outerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        outerPanel.setLayout(new BorderLayout());
        outerPanel.add(_compressedViewCheckbox, BorderLayout.WEST);
        final JPanel innerPanel = new JPanel();
        innerPanel.add(_davObjSelection);
        innerPanel.add(Box.createHorizontalStrut(5));
        innerPanel.add(refreshButton);
        outerPanel.add(innerPanel, BorderLayout.EAST);
        _pane.add(outerPanel, BorderLayout.SOUTH);
    }

    /**
     * Stellt die ausgewählte Datenidentifikation dar.
     *
     * @param systemObject das darzustellende Systemobjekt
     *
     * @return die ausgewählte Datenidentifikation als JPanel
     */
    private JPanel getHeaderPanel(final SystemObject systemObject) {
        JLabel objLabel = new JLabel("Objekt: ");

        JTextField objTextField = new JTextField(systemObject.getNameOrPidOrId());
        objTextField.setEditable(false);
        objTextField.setFocusable(false);

        // anordnen der Komponenten
        GridBagConstraints gbc;
        GridBagLayout gbl = new GridBagLayout();
        JPanel headerPanel = new JPanel();
        headerPanel.setLayout(gbl);

        // Objekt
        gbc = makegbc(0, 2, 1, 1);
        gbc.anchor = GridBagConstraints.WEST;
        gbl.setConstraints(objLabel, gbc);
        headerPanel.add(objLabel);

        gbc = makegbc(1, 2, 1, 1);
        gbc.weightx = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbl.setConstraints(objTextField, gbc);
        headerPanel.add(objTextField);

        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Applikation"));
        panel.add(headerPanel, BorderLayout.WEST);

        return panel;
    }

    /**
     * Hilfsmethode für das GridBagLayout zur Positionierung der Elemente.
     *
     * @param x      die x-Position im Grid
     * @param y      die y-Position im Grid
     * @param width  gibt die Anzahl der Spalten an, die die Komponente nutzen soll
     * @param height gibt die Anzahl der Zeilen an, die die Komponente nutzen soll
     *
     * @return die Rahmenbedingungen für eine Komponente
     */
    private GridBagConstraints makegbc(int x, int y, int width, int height) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.insets = new Insets(1, 5, 1, 1);
        return gbc;
    }

    public void start() {
        pack();
        setLocationRelativeTo(null);
        setVisible(true);
    }

    private class RefreshListener implements ActionListener {

        public void actionPerformed(final ActionEvent e) {
            final JPanel newPanel;
            if (_compressedViewCheckbox.isSelected()) {
                newPanel = new CompressedAppSubscriptionsPanel((ClientDavConnection) _connection, _application,
                                                               (DavApplication) _davObjSelection.getSelectedItem());
            } else {
                newPanel =
                    new AppSubscriptionsPanel((ClientDavConnection) _connection, _application, (DavApplication) _davObjSelection.getSelectedItem());
            }
            _pane.remove(_subscriptionsPanel);
            _pane.add(newPanel, BorderLayout.CENTER);
            _subscriptionsPanel = newPanel;
            pack();
        }
    }

}
