/*
 * Copyright 2011-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.pat.sysbed.
 *
 * de.bsvrz.pat.sysbed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.pat.sysbed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.pat.sysbed.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.pat.sysbed.plugins.subscriptions;

import static de.bsvrz.pat.sysbed.plugins.subscriptions.SubscriptionsPanel.stateToString;


import de.bsvrz.dav.daf.main.ApplicationSubscriptionInfo;
import de.bsvrz.dav.daf.main.ClientDavConnection;
import de.bsvrz.dav.daf.main.config.ClientApplication;
import de.bsvrz.dav.daf.main.config.DavApplication;
import de.bsvrz.sys.funclib.kappich.selectionlist.SelectionList;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/**
 * @author Kappich Systemberatung
 * @version $Revision: 11467 $
 */
public class AppSubscriptionsPanel extends JPanel {

    private final JSplitPane _jSplitPane;

    private final JEditorPane _label;

    private final SelectionList<ApplicationSubscriptionInfo.ApplicationSendingSubscription> _senderList;

    private final SelectionList<ApplicationSubscriptionInfo.ApplicationReceivingSubscription> _receiverList;

    public AppSubscriptionsPanel(final ClientDavConnection connection, final ClientApplication clientApplication, final DavApplication dav) {
        super(new BorderLayout());
        _jSplitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
        ApplicationSubscriptionInfo subscriptionInfo;
        try {
            subscriptionInfo = connection.getSubscriptionInfo(dav, clientApplication);
        } catch (IOException e) {
            subscriptionInfo = null;
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Konnte die Anmeldungen nicht auflisten. " + e.getMessage());
        }
        final TitledBorder labelBorder = BorderFactory.createTitledBorder("Details");
        final JComponent paneSend = new JPanel(new BorderLayout());
        _senderList = new SelectionList<>("Sende-Anmeldungen", "Sende-Anmeldungen",
                                          (pattern, id, object) -> (pattern != null && pattern.matcher(object.toString()).find()) ||
                                                                   object.getObjectId() == id || object.getUsageId() == id,
                                          SelectionList.FilterStyle.HiddenFilter, null);
        _senderList.setElements(subscriptionInfo == null ? Collections.emptyList() : subscriptionInfo.getSenderSubscriptions());
        _senderList.setListRenderer(IconRenderer.getInstance());
        paneSend.add(_senderList, BorderLayout.CENTER);

        final JComponent paneReceive = new JPanel(new BorderLayout());
        _receiverList = new SelectionList<>("Empfangs-Anmeldungen", "Empfangs-Anmeldungen",
                                            (pattern, id, object) -> (pattern != null && pattern.matcher(object.toString()).find()) ||
                                                                     object.getObjectId() == id || object.getUsageId() == id,
                                            SelectionList.FilterStyle.HiddenFilter, null);
        _receiverList.setElements(subscriptionInfo == null ? Collections.emptyList() : subscriptionInfo.getReceiverSubscriptions());
        _receiverList.setListRenderer(IconRenderer.getInstance());
        paneReceive.add(_receiverList, BorderLayout.CENTER);

        _jSplitPane.setLeftComponent(paneSend);
        _jSplitPane.setRightComponent(paneReceive);
        _jSplitPane.setResizeWeight(0.5);
        _senderList.addListSelectionListener(new MySelectionListener<>(_senderList));
        _receiverList.addListSelectionListener(new MySelectionListener<>(_receiverList));
        _senderList.setFocusable(false);
        _receiverList.setFocusable(false);
        this.add(_jSplitPane, BorderLayout.CENTER);
        _label = new JEditorPane("text/html", "");
        _label.putClientProperty(JEditorPane.HONOR_DISPLAY_PROPERTIES, Boolean.TRUE);
        _label.setFont(_label.getFont().deriveFont(Font.PLAIN));
        _label.setBorder(labelBorder);
        _label.setEditable(false);
        final JScrollPane pane = new JScrollPane(_label);
        pane.setBorder(BorderFactory.createEmptyBorder());
        pane.setPreferredSize(new Dimension(400, 160));
        this.add(pane, BorderLayout.SOUTH);
    }

    private void showSubscriptionInfo(final ApplicationSubscriptionInfo.ApplicationReceivingSubscription clientReceivingSubscription) {
        _senderList.clearSelection();
        _label.setText("<html>" + "<b>Objekt: </b>" + clientReceivingSubscription.getObject() + "<br>" + "<b>Attributgruppe: </b>" +
                       clientReceivingSubscription.getUsage().getAttributeGroup() + "<br>" + "<b>Aspekt: </b>" +
                       clientReceivingSubscription.getUsage().getAspect() + "<br>" + "<b>Simulationsvariante: </b>" +
                       clientReceivingSubscription.getSimVar() + "<br>" + "<b>Typ: </b>" +
                       (clientReceivingSubscription.isDrain() ? "Senke" : "Empfänger") + "<br>" + "<b>Nachgelieferte Daten: </b>" +
                       (clientReceivingSubscription.isDelayed() ? "Ja" : "Nein") + "<br>" + "<b>Nur Änderungen: </b>" +
                       (clientReceivingSubscription.isDelta() ? "Ja" : "Nein") + "<br>" + "<b>Status: </b>" +
                       stateToString(clientReceivingSubscription.getState()));
    }

    private void showSubscriptionInfo(final ApplicationSubscriptionInfo.ApplicationSendingSubscription clientSendingSubscription) {
        _receiverList.clearSelection();
        _label.setText("<html>" + "<b>Objekt: </b>" + clientSendingSubscription.getObject() + "<br>" + "<b>Attributgruppe: </b>" +
                       clientSendingSubscription.getUsage().getAttributeGroup() + "<br>" + "<b>Aspekt: </b>" +
                       clientSendingSubscription.getUsage().getAspect() + "<br>" + "<b>Simulationsvariante: </b>" +
                       clientSendingSubscription.getSimVar() + "<br>" + "<b>Typ: </b>" +
                       (clientSendingSubscription.isSource() ? "Quelle" : "Sender") + "<br>" + "<b>Unterstützt Sendesteuerung: </b>" +
                       (clientSendingSubscription.isRequestSupported() ? "Ja" : "Nein") + "<br>" + "<b>Status: </b>" +
                       stateToString(clientSendingSubscription.getState()));
    }

    private class MySelectionListener<T> implements ListSelectionListener {

        private final SelectionList<T> _list;

        public MySelectionListener(final SelectionList<T> list) {
            _list = list;
        }

        @Override
        public void valueChanged(final ListSelectionEvent e) {
            List<T> selectedValues = _list.getSelectedValues();
            if (selectedValues.isEmpty()) {
                return;
            }
            final T element = selectedValues.get(0);
            if (element instanceof ApplicationSubscriptionInfo.ApplicationSendingSubscription) {
                showSubscriptionInfo((ApplicationSubscriptionInfo.ApplicationSendingSubscription) element);
            }
            if (element instanceof ApplicationSubscriptionInfo.ApplicationReceivingSubscription) {
                showSubscriptionInfo((ApplicationSubscriptionInfo.ApplicationReceivingSubscription) element);
            }
        }
    }
}
