/*
 * Copyright 2014-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.pat.sysbed.
 *
 * de.bsvrz.pat.sysbed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.pat.sysbed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.pat.sysbed.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.pat.sysbed.preselection.lists;

import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.pat.sysbed.main.SelectionModel;
import de.bsvrz.pat.sysbed.main.TooltipAndContextUtil;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.collections.CollatorComparator;
import de.bsvrz.sys.funclib.kappich.selectionlist.SelectionList;
import java.util.List;
import java.util.Locale;
import javax.swing.JPopupMenu;

/**
 * Klasse, die eine Gruppe zur Objektauswahl kapselt. Oben befindet sich eine Überschrift mit der Anzahl der ausgewählten Objekte und einem Button zum
 * deselektieren, darunter befindet sich die Liste der Objekte
 *
 * @author Kappich Systemberatung
 * @version $Revision: 000 $
 */
public class SystemObjectSelectionList<T extends SystemObject> extends SelectionList<T> implements SelectionModel {

    private static final Debug _debug = Debug.getLogger();

    public SystemObjectSelectionList() {
        this("", "", FilterStyle.NoHeader);
    }

    public SystemObjectSelectionList(final String header, final String headerPlural) {
        this(header, headerPlural, FilterStyle.HiddenFilter);
    }

    public SystemObjectSelectionList(final String header, final String headerPlural, final FilterStyle filterStyle) {
        super(header, headerPlural,
              (pattern, id, object) -> pattern == null || pattern.matcher(object.getPid()).find() || pattern.matcher(object.getName()).find() ||
                                       id == object.getId(), filterStyle, new CollatorComparator<>(SystemObject::getNameOrPidOrId, Locale.GERMANY));
        TooltipAndContextUtil.createComponentPopupMenu(this);
    }

    @Override
    public String getTooltip(final T object) {
        String tooltip = super.getTooltip(object);
        if (tooltip == null) {
            return TooltipAndContextUtil.getTooltip(object);
        }
        return TooltipAndContextUtil.getTooltip(object) + "<br>" + tooltip;
    }

    @Override
    public List<T> getSelectedObjects() {
        return getSelectedValues();
    }

    @Override
    public void setListPopupMenu(final JPopupMenu popup) {
        _jList.setComponentPopupMenu(popup);
    }
}
