/*
 * Copyright 2012-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.sys.funclib.commandLineArgs.
 *
 * de.bsvrz.sys.funclib.commandLineArgs is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.sys.funclib.commandLineArgs is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.sys.funclib.commandLineArgs; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.sys.funclib.commandLineArgs;

/**
 * @author Kappich Systemberatung
* @deprecated Klasse wird in einem zukünftigen Release entfernt. Die Funktionalität ist in der {@link ArgumentList}-Klasse vorhanden.
 */
@Deprecated
public final class ScaleUnit {

    /**
     * Wandelt die Masseinheit in einem Faktor um. Dabei wird typische Masseinheiten in der IT-Technik verwendet, mit der 2er Potenz
     *
     * @param scaleUnit Messeinheit z.B. kiB, GiB, TiB usw.
     *
     * @return
     */
    public static long getScaleFactorBinary(final String scaleUnit) {
        if (scaleUnit == null) {
            throw new IllegalArgumentException("Ihre Präfix-Angabe ist ungültig. " + scaleUnit);
        }
        if (scaleUnit.isEmpty()) {
            return 1;
        }
	    return switch (scaleUnit.toLowerCase().charAt(0)) {
		    case 'k' -> 1024;
		    case 'm' -> 1024 * 1024;
		    case 'g' -> 1024 * 1024 * 1024;
		    case 't' -> 1024L * 1024L * 1024L * 1024L;
		    case 'p' -> 1024L * 1024L * 1024L * 1024L * 1024L;
		    case 'e' -> 1024L * 1024L * 1024L * 1024L * 1024L * 1024L;
		    default -> throw new IllegalScaleUnitException("Ihre Angabe ist keine gültige Einheit! " + scaleUnit);
	    };
    }

    /**
     * Wandelt die Masseinheit in einem Faktor um.
     *
     * @param scaleUnit Messeinheit z.B. kilo, Giga, Terra usw.
     *
     * @return
     */
    public static long getScaleFactorDecimal(final String scaleUnit) {
        if (scaleUnit == null) {
            throw new IllegalArgumentException("Ihre Präfix-Angabe ist ungültig. " + scaleUnit);
        }
        if (scaleUnit.isEmpty()) {
            return 1;
        }
	    return switch (scaleUnit.toLowerCase().charAt(0)) {
		    case 'h' -> 100;
		    case 'k' -> 1000;
		    case 'm' -> 1000 * 1000;
		    case 'g' -> 1000 * 1000 * 1000;
		    case 't' -> 1000L * 1000L * 1000L * 1000L;
		    case 'p' -> 1000L * 1000L * 1000L * 1000L * 1000L;
		    case 'e' -> 1000L * 1000L * 1000L * 1000L * 1000L * 1000L;
		    default -> throw new IllegalScaleUnitException("Ihre Angabe ist keine gültige Einheit! " + scaleUnit);
	    };
    }

    /**
     * Wandelt die Masseinheit in einem Faktor um.
     *
     * @param scaleUnit Messeinheit z.B. kilo, Giga, Terra usw.
     *
     * @return
     */
    public static double getScaleFactorDecimalFloatingPoint(final String scaleUnit) {
        if (scaleUnit == null) {
            throw new IllegalArgumentException("Ihre Präfix-Angabe ist ungültig. " + scaleUnit);
        }
        if (scaleUnit.isEmpty()) {
            return 1;
        }
	    return switch (scaleUnit.toLowerCase().charAt(0)) {
		    case 'd' -> 0.1;
		    case 'c' -> 0.01;
		    case 'm' -> 0.001;
		    case 'y' -> 0.000001;
		    case 'n' -> 0.000000001;
		    case 'p' -> 0.000000000001;
		    case 'f' -> 0.000000000000001;
		    case 'a' -> 0.000000000000000001;
		    case 'z' -> 0.000000000000000000001;
		    default -> throw new IllegalScaleUnitException("Ihre Angabe ist keine gültige Einheit! " + scaleUnit);
	    };
    }

    private static class IllegalScaleUnitException extends IllegalArgumentException {
        public IllegalScaleUnitException(final String message) {
            super(message);
        }
    }
}
