/*
 * Copyright 2006 by Kappich+Kniß Systemberatung Aachen (K2S)
 * Copyright 2007-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.configBrowser.
 *
 * de.kappich.pat.configBrowser is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.configBrowser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.configBrowser.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.configBrowser.main;

import de.bsvrz.puk.config.configFile.datamodel.ConfigDataModel;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.debug.Debug;
import java.io.File;

/**
 * Dieser Konfigurations-Browser stellt das {@link de.bsvrz.puk.config.configFile.datamodel.ConfigDataModel neue Datenmodell} grafisch aufbereitet
 * dar.
 *
 * @author Kappich Systemberatung
*/
public final class ConfigConfigurationViewer {
    private static Debug _debug;

    public ConfigConfigurationViewer(File configurationFile) {
        final ConfigDataModel configuration = new ConfigDataModel(configurationFile);
        _debug.info("Das Datenmodell wurde geladen!");
        final Runnable autoCloser = new Runnable() {
            public void run() {
                configuration.close();
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(autoCloser));

        DataModelTreePanel.showTreeFrame(configuration);
        _debug.info("fertig");
        System.out.println("fertig");     // falls eins nicht erscheint
    }

    public static void main(String[] args) {
        ArgumentList argumentList = new ArgumentList(args);
        Debug.init("KonfigurationsBrowserNeu", argumentList);
        _debug = Debug.getLogger();
        File configurationFile;
        if (argumentList.hasArgument("-konfiguration")) {
            configurationFile = argumentList.fetchArgument("-konfiguration").asFile();
        } else {
            throw new IllegalArgumentException("Die Verwaltungsdatei der Konfiguration wurde nicht angegeben (-konfiguration=...).");
        }
        new ConfigConfigurationViewer(configurationFile);
    }

}
