/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.sys.funclib.kappich.
 *
 * de.bsvrz.sys.funclib.kappich is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.sys.funclib.kappich is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.sys.funclib.kappich; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.sys.funclib.kappich.properties;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;


import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Definiert ein Field oder eine Methode einer Klasse als relevant für die {@link ObjectProperties}-Klasse bzw. als Relevant für die Anzeige an den
 * Benutzer in einem Eigenschaften-Fenster o.ä.
 *
 * @author Kappich Systemberatung
*/
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Target(value = {METHOD, FIELD})
public @interface PropertyName {

    /**
     * Anzeigename der Eigenschaft
     *
     * @return Anzeigename
     */
    String name();

    /**
     * Gibt den Sortierschlüssel zurück, nach dem die Eigenschaften sortiert werden sollen. Standardmäßig Short.MAX_VALUE
     *
     * @return den Sortierschlüssel
     */
    int sortKey() default Short.MAX_VALUE;

    /**
     * Gibt die Basis-Einheit zurück, z.B. "m" für Meter
     *
     * @return Einheit
     */
    String unit() default "";

    /**
     * Gibt die Potenz zurück. Bei Quadratmetern sollte die Einheit bspw. "m" sein und die Potenz 2.
     *
     * @return die Potenz
     */
    int power() default 1;

    /**
     * Mit diesem Faktor werden alle Rohwerte multipliziert, bevor sie dargestellt werden. Liegen die Daten als cm vor, muss bspw. als faktor 0.01
     * angegeben werden um diese in Meter umzurechnen.
     *
     * @return Faktor
     */
    double factor() default 1.0;

    /**
     * Mit diesem {@link PropertyFormatter} werden die Objekte zu Strings formatiert.
     *
     * @return die {@code PropertyFormatter}-Klasse
     */
    Class<? extends PropertyFormatter> getFormatter() default DefaultFormatter.class;
}
