/*
 * Copyright 2003 by Kappich+Kniß Systemberatung Aachen (K2S)
 * Copyright 2007-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.pat.onlprot.
 *
 * de.bsvrz.pat.onlprot is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.pat.onlprot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.pat.onlprot.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.pat.onlprot.standardProtocolModule;

import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import java.io.PrintWriter;

/**
 * Festlegung der Funktionalität von Protokollierungsmodulen
 * <p>
 * Ein Protokollierungsmodul muß folgende Methoden zur Vergügung stellen <ul> <li> {@code initProtocol}	- Initialisierung <li> {@code
 * closeProtocol}	-
 * Abschluß der Protokollierung </ul>
 *
 * @author Kappich Systemberatung
 */
public interface ProtocolModuleInterface {

    /**
     * Gibt Information über die Aufrufparameter des Protokollierungsmoduls zurück
     *
     * @return String mit der Beschreibung der erlaubten Aufrufparameter und deren erwartetes Format
     */
    public abstract String getHelp();

    /**
     * Führt die Initialisierungsschritte des Protokollierungsmoduls aus.
     *
     * @param argumentList {@link de.bsvrz.sys.funclib.commandLineArgs.ArgumentList} der noch nicht ausgewerteten Aufrufparameter der Applikation
     * @param protocolFile PrintWriter der protokollierten	Datensequenzen
     * @param args         String[] mit den Aufrufparametern der Applikation
     *
     * @return ClientReceiverInterface-Handle auf den benutzten Protokollierer
     */
    public ClientReceiverInterface initProtocol(ArgumentList argumentList, PrintWriter protocolFile, String[] args);

    /** Führt Aufräumarbeiten nach Beendigung des Protokollierens aus. */
    public abstract void closeProtocol();
}
