/*
 * Copyright 2018-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.puk.config.
 *
 * de.bsvrz.puk.config is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.puk.config is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.puk.config.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.puk.config.configFile.datamodel;

import java.util.ArrayList;
import java.util.List;

/**
 * Implementierung von {@link MutableSetStorage}, die die Objekte im Speicher hält (für änderbare Mengen, die nur transiente Objekte enthalten, wie
 * die Menge der Applikationen)
 *
 * @author Kappich Systemberatung
 */
public class TransientMutableSetStorage extends MutableSetStorage {

    /**
     * Die gespeicherten Elemente
     */
    private List<MutableElement> _elements = List.of();

    @Override
    protected void writeElements(final List<MutableElement> mutableElements) {
	    _elements = List.copyOf(mutableElements);
    }

    @Override
    protected List<MutableElement> readElements() {
        return new ArrayList<>(_elements);
    }
}
