/*
 * Copyright 2005 by Kappich+Kniß Systemberatung Aachen (K2S)
 * Copyright 2007-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.sys.funclib.consoleProcessFrame.
 *
 * de.bsvrz.sys.funclib.consoleProcessFrame is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.sys.funclib.consoleProcessFrame is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.sys.funclib.consoleProcessFrame; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.sys.funclib.consoleProcessFrame;

import java.awt.BorderLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;

/**
 * Implementiert ein Fenster, das mit einem externen Java-Prozess verbunden ist. Der Prozess wird beim Erzeugen des Fensters gestartet und beim
 * Schließen des Fensters beendet. Die Textausgaben des Prozesses werden im Fenster dargestellt.
 *
 * @author Kappich Systemberatung
*/
public class ConsoleProcessFrame extends JFrame {

    private final ConsoleProcessPanel _consoleProcessPanel;

    protected ConsoleProcessFrame(String title, ConsoleProcessPanel consoleProcessPanel) {
        super(title);
        _consoleProcessPanel = consoleProcessPanel;
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                _consoleProcessPanel.killProcess();
            }
        });
        getContentPane().add(_consoleProcessPanel, BorderLayout.CENTER);
        pack();
        setVisible(true);
        setLocationRelativeTo(null);
    }

    /**
     * Erstellt einen ConsoleProcessFrame für einen Java-Prozess auf.
     *
     * @param title       Titel
     * @param className   Klassenname
     * @param arguments   Argumente
     * @param environment Umgebungsvariablen
     *
     * @return Frame
     */
    public static ConsoleProcessFrame createJavaProcessFrame(String title, String className, String[] arguments, String[] environment,
                                                             File workingDirectory) throws IOException {
        ConsoleProcessPanel panel = ConsoleProcessPanel.createJavaProcessPanel(className, arguments, environment, workingDirectory);
        ConsoleProcessFrame frame = createConsoleProcessFrame(title, panel);
        panel.start();
        return frame;
    }

    /**
     * Erstellt einen ConsoleProcessFrame.
     *
     * @param title               Titel
     * @param consoleProcessPanel Panel
     *
     * @return Frame
     *
     * @since 3.14
     */
    public static ConsoleProcessFrame createConsoleProcessFrame(String title, ConsoleProcessPanel consoleProcessPanel) {
        return new ConsoleProcessFrame(title, consoleProcessPanel);
    }
}
