/*
 * Copyright 2018-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.dav.
 *
 * de.bsvrz.dav.dav is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.dav is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.dav.dav.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.dav.dav.subscriptions;

import de.bsvrz.dav.daf.communication.lowLevel.telegrams.ApplicationDataTelegram;
import java.util.List;

/**
 * Eine Liste von zusammengehörigen Applikationstelegrammen (die gesplittet wurde), zusammen mti der ID der sendenden Applikation (-1 falls
 * unbekannt)
 *
 * @author Kappich Systemberatung
 */
public class DataTelegramList {

    /**
     * Telegramme
     */
    private List<ApplicationDataTelegram> _telegrams;

    /**
     * Applikations-ID
     */
    private long _applicationId;

    /**
     * Erstellt eine neue DataTelegramList
     *
     * @param telegrams     Telegramme
     * @param applicationId Applikations-ID
     */
    public DataTelegramList(final List<ApplicationDataTelegram> telegrams, final long applicationId) {
        _telegrams = List.copyOf(telegrams);
        _applicationId = applicationId;
    }

    /**
     * Gibt die Telegramme zurück
     *
     * @return die Telegramme
     */
    public List<ApplicationDataTelegram> getTelegrams() {
        return _telegrams;
    }

    /**
     * Gibt die Applikations-ID zurück
     *
     * @return die Applikations-ID, oder -1 falls nicht bekannt, oder 0 falls lokale Konfiguration
     */
    public long getApplicationId() {
        return _applicationId;
    }
}
