/*
 * Copyright 2011-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.dav.
 *
 * de.bsvrz.dav.dav is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.dav is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.dav.dav.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.dav.dav.subscriptions;

/**
 * Interface für eine Anmeldung, die Daten sendet
 *
 * @author Kappich Systemberatung
 * @version $Revision: 11435 $
 */
public interface SendingSubscription extends Subscription {

    /**
     * Gibt {@code true} zurück, wenn es sich um eine Quelle handelt
     *
     * @return {@code true}, wenn es sich um eine Quelle handelt, sonst (Sender) {@code false}
     */
    public boolean isSource();

    /**
     * Gibt {@code true} zurück, wenn der Sender spezifiziert hat, dass er Sendesteuerung benutzen möchte. Hat nur eine Wirkung bei lokalen
     * Anmeldungen.
     *
     * @return {@code true}, wenn der Sender spezifiziert hat, dass er Sendesteuerung benutzen möchte, sonst {@code false}
     */
    public boolean isRequestSupported();

    /**
     * Gibt den Status der Anmeldung zurück
     *
     * @return den Status der Anmeldung
     */
    public SenderState getState();

    /**
     * Setzt den Status der Anmeldung
     *
     * @param senderState          neuer Status
     * @param centralTransmitterId
     */
    public void setState(SenderState senderState, final long centralTransmitterId);
}
