/*
 * Copyright 2019-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.daf.
 *
 * de.bsvrz.dav.daf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.daf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.dav.daf; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.dav.daf.accessControl;

import de.bsvrz.dav.daf.accessControl.internal.UserAction;
import de.bsvrz.dav.daf.communication.lowLevel.telegrams.BaseSubscriptionInfo;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.ObjectSetType;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;

/**
 * Interface, das ein BenutzerInfo-Objekt repräsentiert, das nach verschiedenen Berechtigungen gefragt werden kann.
 *
 * @author Kappich Systemberatung
 */
public interface UserInfo {

    /**
     * Prüft, ob die angegebenen Daten beim Datenverteiler angemeldet werden dürfen.
     *
     * @param info   Daten-Anmeldungs-Informationen
     * @param action Art der Datenanmeldung
     *
     * @return {@code true}, wenn die Daten angemeldet werden dürfen, sonst {@code false}.
     */
    boolean maySubscribeData(BaseSubscriptionInfo info, UserAction action);

    /**
     * Prüft, ob die angegebenen Daten beim Datenverteiler angemeldet werden dürfen.
     *
     * @param object         Objekt, das verwendet wird
     * @param attributeGroup Attributgruppe der Daten
     * @param aspect         Aspekt der Daten
     * @param action         Art der Datenanmeldung
     *
     * @return {@code true}, wenn die Daten angemeldet werden dürfen, sonst {@code false}.
     */
    boolean maySubscribeData(SystemObject object, AttributeGroup attributeGroup, Aspect aspect, UserAction action);

    /**
     * Prüft ob ein Objekt mit den angegeben Daten erstellt, verändert oder gelöscht werden darf
     *
     * @param area Konfigurationsbereich
     * @param type Typ des Objekts
     *
     * @return {@code true}, wenn das Objekt erstellt werden darf, sonst {@code false}.
     */
    boolean mayCreateModifyRemoveObject(final ConfigurationArea area, final SystemObjectType type);

    /**
     * Prüft ob eine Menge mit den angegebenen Daten verändert werden darf
     *
     * @param area Konfigurationsbereich
     * @param type Typ der Menge
     *
     * @return {@code true}, wenn die Menge verändert werden darf, sonst {@code false}.
     */
    boolean mayModifyObjectSet(final ConfigurationArea area, final ObjectSetType type);

    /**
     * Id, die das Systemobjekt des Benutzers darstellt.
     *
     * @return Id, mit der das Systemobjekt des Benutzers angefordert werden kann.
     */
    long getUserId();

    /**
     * Meldet einen Listener auf geänderte Nutzerrechte an
     *
     * @param listener Listener
     */
    void addChangeListener(AccessControlChangeListener listener);

    /**
     * Entfernt einen Listener auf geänderte Benutzerrechte
     *
     * @param listener Listener
     */
    void removeChangeListener(AccessControlChangeListener listener);
}
