/*
 * Copyright 2019-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.daf.
 *
 * de.bsvrz.dav.daf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.daf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.dav.daf; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

/**
 * TBD Dokumentation
 *
 * @author Kappich Systemberatung
 */

package de.bsvrz.dav.daf.accessControl.internal;

import de.bsvrz.dav.daf.accessControl.AccessControlChangeListener;
import de.bsvrz.dav.daf.accessControl.AccessControlManager;
import de.bsvrz.dav.daf.accessControl.UserInfo;
import de.bsvrz.dav.daf.communication.lowLevel.telegrams.BaseSubscriptionInfo;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.ObjectSetType;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;

/**
 * {@link AccessControlManager}-Implementierung, die alles erlaubt (bei deaktivierter Rechteprüfung)
 *
 * @author Kappich Systemberatung
 * @version $Revision: 0000 $
 */
public class DummyAccessControlManager implements AccessControlManager {

    private final long _myUserId;

    public DummyAccessControlManager(final long myUserId) {
        _myUserId = myUserId;
    }

    @Override
    public UserInfo getUserPermissions(final long userId) {
        return new AllUserPermissions(userId);
    }

    @Override
    public UserInfo getUserPermissions() {
        return new AllUserPermissions(_myUserId);
    }

    @Override
    public void addChangeListener(final AccessControlChangeListener listener) {
        // Tut nichts, keine Änderungen möglich
    }

    @Override
    public void removeChangeListener(final AccessControlChangeListener listener) {
        // Tut nichts, keine Änderungen möglich
    }

    public static class NoUserPermissions implements UserInfo {
        private final long _userId;

        public NoUserPermissions(final long userId) {
            _userId = userId;
        }

        @Override
        public boolean maySubscribeData(final BaseSubscriptionInfo info, final UserAction action) {
            return false;
        }

        @Override
        public boolean maySubscribeData(final SystemObject object, final AttributeGroup attributeGroup, final Aspect aspect,
                                        final UserAction action) {
            return false;
        }

        @Override
        public boolean mayCreateModifyRemoveObject(final ConfigurationArea area, final SystemObjectType type) {
            return false;
        }

        @Override
        public boolean mayModifyObjectSet(final ConfigurationArea area, final ObjectSetType type) {
            return false;
        }

        @Override
        public long getUserId() {
            return _userId;
        }

        @Override
        public void addChangeListener(final AccessControlChangeListener listener) {
        }

        @Override
        public void removeChangeListener(final AccessControlChangeListener listener) {
        }

        @Override
        public String toString() {
            return "<Unbekannter Benutzer: " + _userId + ">";
        }
    }

    public static class AllUserPermissions implements UserInfo {
        private final long _userId;

        public AllUserPermissions(final long userId) {
            _userId = userId;
        }

        @Override
        public boolean maySubscribeData(final BaseSubscriptionInfo info, final UserAction action) {
            return true;
        }

        @Override
        public boolean maySubscribeData(final SystemObject object, final AttributeGroup attributeGroup, final Aspect aspect,
                                        final UserAction action) {
            return true;
        }

        @Override
        public boolean mayCreateModifyRemoveObject(final ConfigurationArea area, final SystemObjectType type) {
            return true;
        }

        @Override
        public boolean mayModifyObjectSet(final ConfigurationArea area, final ObjectSetType type) {
            return true;
        }

        @Override
        public long getUserId() {
            return _userId;
        }

        @Override
        public void addChangeListener(final AccessControlChangeListener listener) {
        }

        @Override
        public void removeChangeListener(final AccessControlChangeListener listener) {
        }

        @Override
        public String toString() {
            return "<System-Benutzer: " + _userId + ">";
        }
    }
}
