/*
 * Copyright 2005 by Kappich+Kniß Systemberatung Aachen (K2S)
 * Copyright 2007-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.daf.
 *
 * de.bsvrz.dav.daf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.daf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.dav.daf; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.dav.daf.communication.dataRepresentation;

import de.bsvrz.dav.daf.communication.dataRepresentation.datavalue.DataValue;
import de.bsvrz.dav.daf.main.config.Attribute;
import de.bsvrz.dav.daf.main.config.DataModel;
import java.io.DataOutputStream;
import java.io.IOException;

/**
 * @author Kappich Systemberatung
 */
public class AttributeValue extends AttributeBaseValue {

    /** Der Attributeswert */
    private DataValue _value;

    /**
     * Erzeugt ein neues Objekt mit den gegebenen Parametern.
     *
     * @param dataModel Datenmodell
     * @param attribute Attribute
     */
    public AttributeValue(DataModel dataModel, Attribute attribute) {
        super(dataModel, attribute);
    }

    public final Object getValue() {
        return _value;
    }

    public final void setValue(DataValue value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument ist null");
        }
        _value = value;
    }

    public final void writeValue(DataOutputStream out) throws IOException {
        if (_value == null) {
            throw new IOException("Attribut '" + _attribute.getName() + "': Wert = null");
        }
        _value.write(out);
    }

    public final boolean equals(AttributeBaseValue attributeBaseValue) {
        if (attributeBaseValue == null) {
            return false;
        }
        if (_attribute.getId() != attributeBaseValue.getAttribute().getId()) {
            return false;
        }
        try {
            DataValue value1 = (DataValue) attributeBaseValue.getValue();
            if ((_value == null) && (value1 == null)) {
                return true;
            } else if ((_value == null) || (value1 == null)) {
                return false;
            }
            if ((_value != null) && (value1 != null)) {
                return _value.equals(value1);
            }
        } catch (ClassCastException ex) {
        }
        return false;
    }

    /**
     * Gibt den Hashcode zurück
     *
     * @return Hashcode
     */
    public final int hashCode() {
        if (_hashCode == 0) {
            long objectID = _attribute.getId();
            int result = 19;
	        result = (41 * result) + Long.hashCode(objectID);
            _hashCode = result;
        }
        return _hashCode;
    }

    public final AttributeBaseValue clonePlain() {
        return new AttributeValue(_dataModel, _attribute);
    }

    public final AttributeBaseValue cloneObject() {
        AttributeValue clone = new AttributeValue(_dataModel, _attribute);
        if (_value != null) {
            clone.setValue(_value.cloneObject());
        }
        return clone;
    }

    public final boolean hasValue() {
        if (_value == null) {
            return false;
        }
        return true;
    }
}
