/*
 * Copyright 2018-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.daf.
 *
 * de.bsvrz.dav.daf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.daf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.dav.daf; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.dav.daf.communication.dataRepresentation;

/**
 * Hilfsklasse zu {@link UndefinedValueHandler}, die entweder long-Werte oder einen Marker speichert, dass kein Wert vorhanden ist.
 *
 * @author Kappich Systemberatung
 */
abstract class IntegerDefaultValue {
    static final class IntegerDefaultValueAbsent extends IntegerDefaultValue {
        private static final IntegerDefaultValueAbsent INSTANCE = new IntegerDefaultValueAbsent();

        private IntegerDefaultValueAbsent() {
        }

        public static IntegerDefaultValue getInstance() {
            return INSTANCE;
        }

        @Override
        public String toString() {
            return "<Nicht vorhanden>";
        }
    }

    static final class IntegerDefaultValuePresent extends IntegerDefaultValue {
        // Häufig auftretende Werte werden gecacht
        private static final IntegerDefaultValuePresent BYTE_MIN = new IntegerDefaultValuePresent(Byte.MIN_VALUE);
        private static final IntegerDefaultValuePresent SHORT_MIN = new IntegerDefaultValuePresent(Short.MIN_VALUE);
        private static final IntegerDefaultValuePresent INT_MIN = new IntegerDefaultValuePresent(Integer.MIN_VALUE);
        private static final IntegerDefaultValuePresent LONG_MIN = new IntegerDefaultValuePresent(Long.MIN_VALUE);
        private final long _value;

        private IntegerDefaultValuePresent(final long value) {
            _value = value;
        }

        public static IntegerDefaultValue getInstance(final long value) {
            if (value == BYTE_MIN.getValue()) {
                return BYTE_MIN;
            }
            if (value == SHORT_MIN.getValue()) {
                return SHORT_MIN;
            }
            if (value == INT_MIN.getValue()) {
                return INT_MIN;
            }
            if (value == LONG_MIN.getValue()) {
                return LONG_MIN;
            }
            return new IntegerDefaultValuePresent(value);
        }

        public long getValue() {
            return _value;
        }

        @Override
        public String toString() {
            return String.valueOf(_value);
        }

        @Override
        public boolean equals(final Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }

            final IntegerDefaultValuePresent that = (IntegerDefaultValuePresent) o;

            return _value == that._value;
        }

        @Override
        public int hashCode() {
	        return Long.hashCode(_value);
        }
    }
}
