/*
 * Copyright 2004 by Kappich+Kniß Systemberatung, Aachen
 * Copyright 2007-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.daf.
 *
 * de.bsvrz.dav.daf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.daf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.dav.daf; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.dav.daf.communication.dataRepresentation.datavalue;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

/**
 * Diese Klasse stellt die Attribute und Funktionalitäten des Datentyps List zur Verfügung.
 *
 * @author Kappich Systemberatung
 */
public class AttributeListAttribute extends DataValue {

    /** Werte der Daten */
    private DataValue[] _values;

    /** Erzeugt ein neues Objekt ohne Parameter. Die Parameter werden zu einem Späteren Zeitpunkt über die read-Methode eingelesen. */
    public AttributeListAttribute() {
        _type = ATTRIBUTE_LIST_TYPE;
    }

    /**
     * Erzeugt ein neues Objekt mit den gegebenen Parametern.
     *
     * @param _values Werte
     */
    public AttributeListAttribute(DataValue[] _values) {
        _type = ATTRIBUTE_LIST_TYPE;
        this._values = _values;
    }

    @Override
    public final Object getValue() {
        return _values;
    }

    /**
     * Setzt {@code _values}
     *
     * @param values Werte der Daten
     */
    public final void setValue(DataValue[] values) {
        _values = values;
    }

    @Override
    public final DataValue cloneObject() {
        DataValue[] values = null;
        if (_values != null) {
            values = new DataValue[_values.length];
            for (int i = 0; i < _values.length; ++i) {
                values[i] = _values[i].cloneObject();
            }
        }
        return new AttributeListAttribute(values);
    }

    @Override
    public final String parseToString() {
        StringBuilder str = new StringBuilder("Attributliste: [ \n");
        if (_values != null) {
            for (final DataValue _value : _values) {
                if (_value != null) {
                    str.append(_value.parseToString());
                }
            }
        }
        str.append("\n]\n");
        return str.toString();
    }

    @Override
    public final void write(DataOutputStream out) throws IOException {
        if (_values != null) {
            for (final DataValue _value : _values) {
                if (_value != null) {
                    _value.write(out);
                }
            }
        }
    }

    @Override
    public final void read(DataInputStream in) throws IOException {
        if (_values != null) {
            for (final DataValue _value : _values) {
                if (_value != null) {
                    _value.read(in);
                }
            }
        }
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final AttributeListAttribute that = (AttributeListAttribute) o;

        return Arrays.equals(_values, that._values);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(_values);
    }
}
